/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.DefaultHashSeed;
import org.infinispan.distribution.ch.HashSeed;
import org.infinispan.util.hash.Hash;
import org.infinispan.util.hash.MurmurHash3;

public class HashConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder<HashConfiguration> {
    private ConsistentHash consistentHash;
    private Hash hash = new MurmurHash3();
    private HashSeed hashSeed = new DefaultHashSeed();
    private int numOwners = 2;
    private int numVirtualNodes = 1;
    private boolean rehashEnabled = true;
    private long rehashRpcTimeout = TimeUnit.MINUTES.toMillis(10L);
    private long rehashWait = TimeUnit.MINUTES.toMillis(1L);
    private final GroupsConfigurationBuilder groupsConfigurationBuilder;

    HashConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
        this.groupsConfigurationBuilder = new GroupsConfigurationBuilder(builder);
    }

    public HashConfigurationBuilder consistentHash(ConsistentHash consistentHash) {
        this.consistentHash = consistentHash;
        return this;
    }

    public HashConfigurationBuilder hashSeed(HashSeed hashSeed) {
        this.hashSeed = hashSeed;
        return this;
    }

    public HashConfigurationBuilder numOwners(int numOwners) {
        this.numOwners = numOwners;
        return this;
    }

    public HashConfigurationBuilder numVirtualNodes(int numVirtualNodes) {
        this.numVirtualNodes = numVirtualNodes;
        return this;
    }

    public HashConfigurationBuilder rehashEnabled() {
        this.rehashEnabled = true;
        return this;
    }

    public HashConfigurationBuilder rehashDisabled() {
        this.rehashEnabled = false;
        return this;
    }

    public HashConfigurationBuilder rehashRpcTimeout(long rehashRpcTimeout) {
        this.rehashRpcTimeout = rehashRpcTimeout;
        return this;
    }

    public HashConfigurationBuilder rehashWait(long rehashWait) {
        this.rehashWait = rehashWait;
        return this;
    }

    public HashConfigurationBuilder hash(Hash hash) {
        this.hash = hash;
        return this;
    }

    public GroupsConfigurationBuilder groups() {
        return this.groupsConfigurationBuilder;
    }

    @Override
    void validate() {
        this.groupsConfigurationBuilder.validate();
    }

    @Override
    HashConfiguration create() {
        return new HashConfiguration(this.consistentHash, this.hashSeed, this.hash, this.numOwners, this.numVirtualNodes, this.rehashEnabled, this.rehashRpcTimeout, this.rehashWait, this.groupsConfigurationBuilder.create());
    }
}

