/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.configuration.cache.AbstractLoadersConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.LoaderConfigurationChildBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfigurationBuilder;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.util.TypedProperties;

public class LoaderConfigurationBuilder
extends AbstractLoadersConfigurationChildBuilder<LoaderConfiguration>
implements LoaderConfigurationChildBuilder {
    private CacheLoader cacheLoader;
    private boolean fetchPersistentState;
    private boolean ignoreModifications;
    private boolean purgeOnStartup;
    private int purgerThreads;
    private boolean purgeSynchronously;
    private final AsyncLoaderConfigurationBuilder async = new AsyncLoaderConfigurationBuilder(this);
    private final SingletonStoreConfigurationBuilder singletonStore = new SingletonStoreConfigurationBuilder(this);
    private Properties properties;

    LoaderConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public LoaderConfigurationBuilder cacheLoader(CacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
        return this;
    }

    public LoaderConfigurationBuilder fetchPersistentState(boolean b) {
        this.fetchPersistentState = b;
        return this;
    }

    public LoaderConfigurationBuilder ignoreModifications(boolean b) {
        this.ignoreModifications = b;
        return this;
    }

    public LoaderConfigurationBuilder purgeOnStartup(boolean b) {
        this.purgeOnStartup = b;
        return this;
    }

    public LoaderConfigurationBuilder purgerThreads(int i) {
        this.purgerThreads = i;
        return this;
    }

    public LoaderConfigurationBuilder purgeSynchronously(boolean b) {
        this.purgeSynchronously = b;
        return this;
    }

    public LoaderConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public LoaderConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    @Override
    void validate() {
        this.async.validate();
        this.singletonStore.validate();
    }

    @Override
    LoaderConfiguration create() {
        return new LoaderConfiguration(TypedProperties.toTypedProperties(this.properties), this.cacheLoader, this.fetchPersistentState, this.ignoreModifications, this.purgeOnStartup, this.purgerThreads, this.purgeSynchronously, this.async.create(), this.singletonStore.create());
    }

    @Override
    public AsyncLoaderConfigurationBuilder async() {
        return this.async;
    }

    @Override
    public SingletonStoreConfigurationBuilder singletonStore() {
        return this.singletonStore;
    }
}

