/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.AbstractInvocationContext;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.InfinispanCollections;

public class NonTxInvocationContext
extends AbstractInvocationContext {
    private static final int INITIAL_CAPACITY = 4;
    protected BidirectionalLinkedHashMap<Object, CacheEntry> lookedUpEntries = null;
    protected Set<Object> lockedKeys = null;

    @Override
    public CacheEntry lookupEntry(Object k) {
        return this.lookedUpEntries == null ? null : this.lookedUpEntries.get(k);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.initLookedUpEntries();
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> newLookedUpEntries) {
        this.initLookedUpEntries();
        for (Map.Entry<Object, CacheEntry> ce : newLookedUpEntries.entrySet()) {
            this.lookedUpEntries.put(ce.getKey(), ce.getValue());
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries = null;
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? InfinispanCollections.emptyBidirectionalMap() : this.lookedUpEntries;
    }

    @Override
    public boolean isOriginLocal() {
        return this.isContextFlagSet(AbstractInvocationContext.ContextFlag.ORIGIN_LOCAL);
    }

    public void setOriginLocal(boolean originLocal) {
        this.setContextFlag(AbstractInvocationContext.ContextFlag.ORIGIN_LOCAL, originLocal);
    }

    @Override
    public boolean isInTxScope() {
        return false;
    }

    @Override
    public Object getLockOwner() {
        return Thread.currentThread();
    }

    private void initLookedUpEntries() {
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new BidirectionalLinkedHashMap(4);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.clearLookedUpEntries();
        if (this.lockedKeys != null) {
            this.lockedKeys.clear();
        }
    }

    @Override
    public NonTxInvocationContext clone() {
        NonTxInvocationContext dolly = (NonTxInvocationContext)super.clone();
        if (this.lookedUpEntries != null) {
            dolly.lookedUpEntries = new BidirectionalLinkedHashMap<Object, CacheEntry>(this.lookedUpEntries);
        }
        return dolly;
    }

    @Override
    public void addLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = new HashSet<Object>(4);
        }
        this.lockedKeys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.lockedKeys == null ? Collections.emptySet() : this.lockedKeys;
    }

    @Override
    public void clearLockedKeys() {
        this.lockedKeys = null;
    }
}

