/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureImpl;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ManagerImpl
implements L1Manager {
    private static final Log log = LogFactory.getLog(L1ManagerImpl.class);
    private final boolean trace = log.isTraceEnabled();
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private int threshold;
    private final ConcurrentMap<Object, Collection<Address>> requestors = new ConcurrentHashMap<Object, Collection<Address>>();

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CommandsFactory commandsFactory) {
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.threshold = configuration.getL1InvalidationThreshold();
    }

    @Override
    public void addRequestor(Object key, Address origin) {
        ConcurrentHashSet<Address> as = (ConcurrentHashSet<Address>)this.requestors.get(key);
        if (as == null) {
            as = new ConcurrentHashSet<Address>();
            as.add(origin);
            Collection previousAs = this.requestors.putIfAbsent(key, as);
            if (previousAs != null) {
                previousAs.add(origin);
            }
        } else {
            as.add(origin);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public NotifyingNotifiableFuture<Object> flushCache(Collection<Object> keys, Object retval, Address origin) {
        if (this.trace) {
            log.tracef("Invalidating L1 caches for keys %s", keys);
        }
        AggregatingNotifyingFutureImpl future = new AggregatingNotifyingFutureImpl(retval, 2);
        Collection<Address> invalidationAddresses = this.buildInvalidationAddressList(keys, origin);
        int nodes = invalidationAddresses.size();
        if (nodes <= 0) {
            if (!this.trace) return future;
            log.trace("No L1 caches to invalidate");
            return future;
        }
        boolean multicast = this.isUseMulticast(nodes);
        if (this.trace) {
            log.tracef("There are %s nodes involved in invalidation. Threshold is: %s; using multicast: %s", nodes, this.threshold, multicast);
        }
        if (multicast) {
            if (this.trace) {
                log.tracef("Invalidating keys %s via multicast", keys);
            }
            InvalidateCommand ic = this.commandsFactory.buildInvalidateFromL1Command(false, keys);
            this.rpcManager.broadcastRpcCommandInFuture(ic, future);
            return future;
        }
        InvalidateCommand ic = this.commandsFactory.buildInvalidateFromL1Command(false, keys);
        if (this.trace) {
            log.tracef("Keys %s needs invalidation on %s", keys, invalidationAddresses);
        }
        this.rpcManager.invokeRemotelyInFuture(invalidationAddresses, ic, future);
        return future;
    }

    private Collection<Address> buildInvalidationAddressList(Collection<Object> keys, Address origin) {
        HashSet<Address> addresses = new HashSet<Address>();
        for (Object key : keys) {
            Collection as = (Collection)this.requestors.remove(key);
            if (as == null) continue;
            addresses.addAll(as);
        }
        if (origin != null) {
            addresses.remove(origin);
        }
        return addresses;
    }

    private boolean isUseMulticast(int nodes) {
        if (this.threshold == -1) {
            return false;
        }
        if (this.threshold == 0) {
            return true;
        }
        if (!this.rpcManager.getTransport().isMulticastCapable()) {
            return false;
        }
        return nodes > this.threshold;
    }
}

