/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.HashSeed;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.distribution.group.GroupManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.hash.Hash;

public class ConsistentHashHelper {
    public static ConsistentHash removeAddress(ConsistentHash ch, Address toRemove, Configuration c) {
        if (ch instanceof UnionConsistentHash) {
            return ConsistentHashHelper.removeAddressFromUnionConsistentHash((UnionConsistentHash)ch, toRemove, c);
        }
        ConsistentHash newCH = ConsistentHashHelper.constructConsistentHashInstance(c);
        HashSet<Address> caches = new HashSet<Address>(ch.getCaches());
        caches.remove(toRemove);
        newCH.setCaches(caches);
        return newCH;
    }

    private static ConsistentHash constructConsistentHashInstance(Configuration c) {
        Class chClass = Util.loadClass((String)c.getConsistentHashClass(), (ClassLoader)c.getClassLoader());
        Hash h = (Hash)Util.getInstance((String)c.getHashFunctionClass(), (ClassLoader)c.getClassLoader());
        HashSeed hs = c.getHashSeed() != null ? c.getHashSeed() : (HashSeed)Util.getInstance((String)c.getHashSeedClass(), (ClassLoader)c.getClassLoader());
        return ConsistentHashHelper.constructConsistentHashInstance(chClass, h, hs, c.getNumVirtualNodes(), new GroupManagerImpl(c.getGroupers()));
    }

    private static ConsistentHash constructConsistentHashInstance(Class<? extends ConsistentHash> clazz, Hash hashFunction, HashSeed hashSeed, int numVirtualNodes, GroupManager groupManager) {
        ConsistentHash ch = (ConsistentHash)Util.getInstance(clazz);
        if (ch instanceof AbstractWheelConsistentHash) {
            AbstractWheelConsistentHash wch = (AbstractWheelConsistentHash)ch;
            wch.setHashFunction(hashFunction);
            wch.setHashSeed(hashSeed);
            wch.setNumVirtualNodes(numVirtualNodes);
        }
        if (ch instanceof AbstractConsistentHash) {
            AbstractConsistentHash ach = (AbstractConsistentHash)ch;
            if (groupManager != null) {
                ach.setGroupManager(groupManager);
            }
        }
        return ch;
    }

    public static UnionConsistentHash removeAddressFromUnionConsistentHash(UnionConsistentHash uch, Address toRemove, Configuration c) {
        ConsistentHash newFirstCH = ConsistentHashHelper.removeAddress(uch.getOldConsistentHash(), toRemove, c);
        ConsistentHash newSecondCH = ConsistentHashHelper.removeAddress(uch.getNewConsistentHash(), toRemove, c);
        return new UnionConsistentHash(newFirstCH, newSecondCH);
    }

    public static ConsistentHash createConsistentHash(Configuration c, Collection<Address> addresses) {
        ConsistentHash ch = ConsistentHashHelper.constructConsistentHashInstance(c);
        ch.setCaches(ConsistentHashHelper.toSet(addresses));
        return ch;
    }

    public static ConsistentHash createConsistentHash(Configuration c, Collection<Address> addresses, Address ... moreAddresses) {
        HashSet<Address> caches = new HashSet<Address>(addresses);
        caches.addAll(Arrays.asList(moreAddresses));
        return ConsistentHashHelper.createConsistentHash(c, caches);
    }

    public static ConsistentHash createConsistentHash(Configuration c, Collection<Address> addresses, Collection<Address> moreAddresses) {
        HashSet<Address> caches = new HashSet<Address>(addresses);
        caches.addAll(moreAddresses);
        return ConsistentHashHelper.createConsistentHash(c, caches);
    }

    public static ConsistentHash createConsistentHash(ConsistentHash template, Collection<Address> addresses) {
        Hash hf = null;
        HashSeed hs = null;
        int numVirtualNodes = 1;
        GroupManager groupManager = null;
        if (template instanceof AbstractWheelConsistentHash) {
            AbstractWheelConsistentHash wTemplate = (AbstractWheelConsistentHash)template;
            hf = wTemplate.hashFunction;
            hs = wTemplate.hashSeed;
            numVirtualNodes = wTemplate.numVirtualNodes;
            groupManager = wTemplate.groupManager;
        }
        ConsistentHash ch = ConsistentHashHelper.constructConsistentHashInstance(template.getClass(), hf, hs, numVirtualNodes, groupManager);
        if (addresses != null && !addresses.isEmpty()) {
            ch.setCaches(ConsistentHashHelper.toSet(addresses));
        }
        return ch;
    }

    public static ConsistentHash createConsistentHash(ConsistentHash template, Collection<Address> addresses, Address ... moreAddresses) {
        HashSet<Address> caches = new HashSet<Address>(addresses);
        caches.addAll(Arrays.asList(moreAddresses));
        return ConsistentHashHelper.createConsistentHash(template, caches);
    }

    private static Set<Address> toSet(Collection<Address> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new HashSet<Address>(c);
    }
}

