/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={TransactionManager.class})
public class TransactionManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(TransactionManagerFactory.class);

    @Override
    public <T> T construct(Class<T> componentType) {
        if (!this.configuration.isTransactionalCache()) {
            return null;
        }
        TransactionManager transactionManager = null;
        TransactionManagerLookup lookup = this.configuration.getTransactionManagerLookup();
        if (lookup == null && this.configuration.getTransactionManagerLookupClass() != null) {
            lookup = (TransactionManagerLookup)Util.getInstance((String)this.configuration.getTransactionManagerLookupClass(), (ClassLoader)this.configuration.getClassLoader());
        }
        try {
            if (lookup != null) {
                this.componentRegistry.wireDependencies(lookup);
                transactionManager = lookup.getTransactionManager();
            }
        }
        catch (Exception e) {
            log.couldNotInstantiateTransactionManager(e);
        }
        if (transactionManager == null && this.configuration.isInvocationBatchingEnabled()) {
            log.usingBatchModeTransactionManager();
            transactionManager = BatchModeTransactionManager.getInstance();
        }
        if (transactionManager == null) {
            throw new CacheException("This is transactional cache but no transaction manager could be found. Configure the transaction manager lookup properly.");
        }
        return componentType.cast(transactionManager);
    }
}

