/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public interface ClusteringDependentLogic {
    public static final Log log = LogFactory.getLog(ClusteringDependentLogic.class);

    public boolean localNodeIsOwner(Object var1);

    public boolean localNodeIsPrimaryOwner(Object var1);

    public void commitEntry(CacheEntry var1, boolean var2);

    public Collection<Address> getOwners(Collection<Object> var1);

    public static final class DistributionLogic
    implements ClusteringDependentLogic {
        private DistributionManager dm;
        private DataContainer dataContainer;
        private Configuration configuration;
        private RpcManager rpcManager;

        @Inject
        public void init(DistributionManager dm, DataContainer dataContainer, Configuration configuration, RpcManager rpcManager) {
            this.dm = dm;
            this.dataContainer = dataContainer;
            this.configuration = configuration;
            this.rpcManager = rpcManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.dm.getLocality(key).isLocal();
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            List<Address> locate = this.dm.locate(key);
            Address address = this.rpcManager.getAddress();
            boolean result = locate.get(0).equals(address);
            log.tracef("Node owners are %s and my address is %s. Am I main owner? - %b", locate, address, result);
            return result;
        }

        @Override
        public void commitEntry(CacheEntry entry, boolean skipOwnershipCheck) {
            boolean doCommit = true;
            if (!(skipOwnershipCheck || entry.isRemoved() || this.localNodeIsOwner(entry.getKey()))) {
                if (this.configuration.isL1CacheEnabled()) {
                    this.dm.transformForL1(entry);
                } else {
                    doCommit = false;
                }
            }
            if (doCommit) {
                entry.commit(this.dataContainer);
            } else {
                entry.rollback();
            }
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return this.dm.getAffectedNodes(keys);
        }
    }

    public static final class AllNodesLogic
    implements ClusteringDependentLogic {
        private DataContainer dataContainer;
        private RpcManager rpcManager;

        @Inject
        public void init(DataContainer dc, RpcManager rpcManager) {
            this.dataContainer = dc;
            this.rpcManager = rpcManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return true;
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return this.rpcManager == null || this.rpcManager.getTransport().isCoordinator();
        }

        @Override
        public void commitEntry(CacheEntry entry, boolean skipOwnershipCheck) {
            entry.commit(this.dataContainer);
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return null;
        }
    }
}

