/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import org.infinispan.CacheException;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;

public class NonTransactionalLockingInterceptor
extends AbstractLockingInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            this.lockKey(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            for (Object key : command.getMap().keySet()) {
                this.lockKey(ctx, key);
            }
            Object i$ = this.invokeNextInterceptor(ctx, command);
            return i$;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            this.lockKey(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            this.lockKey(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public final Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        ctx.setFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
        return this.visitRemoveCommand(ctx, command);
    }

    private void assertNonTransactional(InvocationContext ctx) {
        if (ctx.isInTxScope()) {
            throw new CacheException("This is a non-transactional cache and cannot be accessed with a transactional InvocationContext.");
        }
    }
}

