/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JmxUtil {
    private static final Log log = LogFactory.getLog(JmxUtil.class);

    public static MBeanServer lookupMBeanServer(GlobalConfiguration cfg) {
        MBeanServerLookup lookup = cfg.getMBeanServerLookupInstance();
        return lookup.getMBeanServer(cfg.getMBeanServerProperties());
    }

    public static String buildJmxDomain(GlobalConfiguration cfg, MBeanServer mBeanServer, String groupName) {
        String configJmxDomain;
        String jmxDomain = JmxUtil.findJmxDomain(cfg.getJmxDomain(), mBeanServer, groupName);
        if (!jmxDomain.equals(configJmxDomain = cfg.getJmxDomain()) && !cfg.isAllowDuplicateDomains()) {
            log.cacheManagerAlreadyRegistered(configJmxDomain);
            throw new JmxDomainConflictException(String.format("Domain already registered %s", configJmxDomain));
        }
        return jmxDomain;
    }

    public static void registerMBean(ResourceDMBean dynamicMBean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        if (!mBeanServer.isRegistered(objectName)) {
            try {
                mBeanServer.registerMBean(dynamicMBean, objectName);
                if (log.isTraceEnabled()) {
                    log.tracef("Registered %s under %s", dynamicMBean, objectName);
                }
            }
            catch (InstanceAlreadyExistsException e) {
                log.couldNotRegisterObjectName(objectName, e);
            }
        } else if (log.isDebugEnabled()) {
            log.debugf("Object name %s already registered", objectName);
        }
    }

    public static void unregisterMBean(ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        if (mBeanServer.isRegistered(objectName)) {
            mBeanServer.unregisterMBean(objectName);
            if (log.isTraceEnabled()) {
                log.tracef("Unregistered %s", objectName);
            }
        }
    }

    private static String findJmxDomain(String jmxDomain, MBeanServer mBeanServer, String groupName) {
        int index = 2;
        String finalName = jmxDomain;
        boolean done = false;
        while (!done) {
            done = true;
            try {
                ObjectName targetName = new ObjectName(finalName + ':' + groupName + ",*");
                if (mBeanServer.queryNames(targetName, null).size() <= 0) continue;
                finalName = jmxDomain + index++;
                done = false;
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException("Unable to check for duplicate names", (Throwable)e);
            }
        }
        return finalName;
    }
}

