/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.Properties;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.util.Util;

class CacheLoaderConfigAdapter
extends XmlAdapter<AbstractCacheStoreConfig, CacheLoaderConfig> {
    CacheLoaderConfigAdapter() {
    }

    public AbstractCacheStoreConfig marshal(CacheLoaderConfig arg0) throws Exception {
        return (AbstractCacheStoreConfig)arg0;
    }

    public CacheLoaderConfig unmarshal(AbstractCacheStoreConfig storeConfig) throws Exception {
        CacheLoaderConfig clc;
        String clClass = storeConfig.getCacheLoaderClassName();
        if (clClass == null || clClass.length() == 0) {
            throw new ConfigurationException("Missing 'class'  attribute for cache loader configuration");
        }
        try {
            clc = this.instantiateCacheLoaderConfig(clClass, storeConfig.getClassLoader());
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate cache loader or configuration", e);
        }
        clc.setCacheLoaderClassName(clClass);
        Properties props = storeConfig.getProperties();
        if (props != null) {
            XmlConfigHelper.setValues(clc, props, false, true);
        }
        if (clc instanceof CacheStoreConfig) {
            AsyncStoreConfig asyncStoreConfig;
            CacheStoreConfig csc = (CacheStoreConfig)clc;
            csc.fetchPersistentState(storeConfig.isFetchPersistentState()).ignoreModifications(storeConfig.isIgnoreModifications()).purgeOnStartup(storeConfig.isPurgeOnStartup()).purgeSynchronously(storeConfig.isPurgeSynchronously()).purgerThreads(storeConfig.getPurgerThreads());
            SingletonStoreConfig singletonStoreConfig = storeConfig.getSingletonStoreConfig();
            if (singletonStoreConfig != null) {
                csc.singletonStore().enabled(singletonStoreConfig.isSingletonStoreEnabled()).pushStateTimeout(singletonStoreConfig.getPushStateTimeout());
            }
            if ((asyncStoreConfig = storeConfig.getAsyncStoreConfig()) != null && asyncStoreConfig.isEnabled().booleanValue()) {
                csc.asyncStore().flushLockTimeout(asyncStoreConfig.getFlushLockTimeout()).shutdownTimeout(asyncStoreConfig.getShutdownTimeout()).threadPoolSize(asyncStoreConfig.getThreadPoolSize()).modificationQueueSize(asyncStoreConfig.getModificationQueueSize());
            }
        }
        return clc;
    }

    private CacheLoaderConfig instantiateCacheLoaderConfig(String cacheLoaderImpl, ClassLoader classLoader) throws Exception {
        Class<? extends CacheLoaderConfig> cacheLoaderConfigType;
        Class clazz = Util.loadClass((String)cacheLoaderImpl, (ClassLoader)classLoader);
        CacheLoaderMetadata metadata = clazz.getAnnotation(CacheLoaderMetadata.class);
        if (metadata == null) {
            CacheLoader cl = (CacheLoader)Util.getInstance((Class)clazz);
            cacheLoaderConfigType = cl.getConfigurationClass();
        } else {
            cacheLoaderConfigType = metadata.configurationClass();
        }
        return (CacheLoaderConfig)Util.getInstance(cacheLoaderConfigType);
    }
}

