/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.MarshallUtil;
import org.infinispan.util.Util;

@Immutable
public class LinkedListExternalizer
extends AbstractExternalizer<LinkedList> {
    public void writeObject(ObjectOutput output, LinkedList list) throws IOException {
        MarshallUtil.marshallCollection((Collection)list, (ObjectOutput)output);
    }

    public LinkedList readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        LinkedList<Object> l = new LinkedList<Object>();
        for (int i = 0; i < size; ++i) {
            l.add(input.readObject());
        }
        return l;
    }

    public Integer getId() {
        return 1;
    }

    public Set<Class<? extends LinkedList>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{LinkedList.class});
    }
}

