/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import org.infinispan.cacheviews.CacheViewsManager;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.CacheViewControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.NamedCacheNotFoundException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class InboundInvocationHandlerImpl
implements InboundInvocationHandler {
    GlobalComponentRegistry gcr;
    private static final Log log = LogFactory.getLog(InboundInvocationHandlerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private StreamingMarshaller marshaller;
    private EmbeddedCacheManager embeddedCacheManager;
    private GlobalConfiguration globalConfiguration;
    private Transport transport;
    private CacheViewsManager cacheViewsManager;
    private static final long timeBeforeWeEnqueueCallForRetry = 10000L;
    private volatile boolean stopping;

    @Inject
    public void inject(GlobalComponentRegistry gcr, @ComponentName(value="org.infinispan.marshaller.global") StreamingMarshaller marshaller, EmbeddedCacheManager embeddedCacheManager, Transport transport, GlobalConfiguration globalConfiguration, CacheViewsManager cacheViewsManager) {
        this.gcr = gcr;
        this.marshaller = marshaller;
        this.embeddedCacheManager = embeddedCacheManager;
        this.transport = transport;
        this.globalConfiguration = globalConfiguration;
        this.cacheViewsManager = cacheViewsManager;
    }

    @Start
    public void start() {
        this.stopping = false;
    }

    @Stop
    public void stop() {
        this.stopping = true;
    }

    private boolean isDefined(String cacheName) {
        return "___defaultcache".equals(cacheName) || this.embeddedCacheManager.getCacheNames().contains(cacheName);
    }

    public void waitForStart(ComponentRegistry componentRegistry) throws InterruptedException {
        StateTransferManager stateTransferManager = componentRegistry.getComponent(StateTransferManager.class);
        if (stateTransferManager != null) {
            stateTransferManager.waitForJoinToComplete();
        }
    }

    public boolean hasJoinStarted(ComponentRegistry componentRegistry) throws InterruptedException {
        StateTransferManager stateTransferManager = componentRegistry.getComponent(StateTransferManager.class);
        if (stateTransferManager != null) {
            return stateTransferManager.hasJoinStarted();
        }
        return true;
    }

    @Override
    public Response handle(CacheRpcCommand cmd, Address origin) throws Throwable {
        cmd.setOrigin(origin);
        if (cmd instanceof CacheViewControlCommand) {
            ((CacheViewControlCommand)cmd).init(this.cacheViewsManager);
            try {
                return new SuccessfulResponse(cmd.perform(null));
            }
            catch (Exception e) {
                return new ExceptionResponse(e);
            }
        }
        String cacheName = cmd.getCacheName();
        ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName);
        if (cr == null) {
            if (!this.globalConfiguration.isStrictPeerToPeer()) {
                return null;
            }
            log.namedCacheDoesNotExist(cacheName);
            return new ExceptionResponse(new NamedCacheNotFoundException(cacheName, "Cache has not been started on node " + this.transport.getAddress()));
        }
        Configuration localConfig = cr.getComponent(Configuration.class);
        cmd.injectComponents(localConfig, cr);
        return this.handleWithRetry(cmd);
    }

    private Response handleInternal(CacheRpcCommand cmd) throws Throwable {
        ComponentRegistry cr = cmd.getComponentRegistry();
        CommandsFactory commandsFactory = cr.getLocalComponent(CommandsFactory.class);
        commandsFactory.initializeReplicableCommand(cmd, true);
        try {
            log.tracef("Calling perform() on %s", cmd);
            ResponseGenerator respGen = cr.getComponent(ResponseGenerator.class);
            Object retval = cmd.perform(null);
            return respGen.getResponse(cmd, retval);
        }
        catch (Exception e) {
            log.trace("Exception executing command", e);
            return new ExceptionResponse(e);
        }
    }

    private Response handleWithWaitForBlocks(CacheRpcCommand cmd) throws Throwable {
        Response resp = this.handleInternal(cmd);
        if (resp != null && !resp.isValid()) {
            log.tracef("Unable to execute command, got invalid response %s", resp);
        }
        return resp;
    }

    private Response handleWithRetry(CacheRpcCommand cmd) throws Throwable {
        boolean isStateTransferCommand = cmd instanceof StateTransferControlCommand;
        if (!isStateTransferCommand && !this.hasJoinStarted(cmd.getComponentRegistry())) {
            log.cacheCanNotHandleInvocations(cmd.getCacheName());
            return new ExceptionResponse(new NamedCacheNotFoundException(cmd.getCacheName(), "Cache has not been started on node " + this.transport.getAddress()));
        }
        return this.handleWithWaitForBlocks(cmd);
    }

    private static enum JoinHandle {
        OK,
        IGNORE;

    }
}

