/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.Transaction;
import org.infinispan.CacheException;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LocalTransaction
extends AbstractCacheTransaction {
    private static final Log log = LogFactory.getLog(LocalTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private Set<Address> remoteLockedNodes;
    private volatile boolean isMarkedForRollback;
    private final Transaction transaction;

    public LocalTransaction(Transaction transaction, GlobalTransaction tx) {
        super(tx);
        this.transaction = transaction;
    }

    public void addModification(WriteCommand mod) {
        if (trace) {
            log.tracef("Adding modification %s. Mod list is %s", mod, this.modifications);
        }
        if (this.modifications == null) {
            this.modifications = new LinkedList();
        }
        this.modifications.add(mod);
    }

    public void locksAcquired(Collection<Address> nodes) {
        log.tracef("Adding remote locks on %s. Remote locks are %s", nodes, this.remoteLockedNodes);
        if (this.remoteLockedNodes == null) {
            this.remoteLockedNodes = new HashSet<Address>();
        }
        this.remoteLockedNodes.addAll(nodes);
    }

    public Collection<Address> getRemoteLocksAcquired() {
        if (this.remoteLockedNodes == null) {
            return Collections.emptySet();
        }
        return this.remoteLockedNodes;
    }

    public void clearRemoteLocksAcquired() {
        if (this.remoteLockedNodes != null) {
            this.remoteLockedNodes.clear();
        }
    }

    public void markForRollback(boolean markForRollback) {
        this.isMarkedForRollback = markForRollback;
    }

    public final boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? InfinispanCollections.emptyBidirectionalMap() : this.lookedUpEntries;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.isMarkedForRollback()) {
            throw new CacheException("This transaction is marked for rollback and cannot acquire locks!");
        }
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new BidirectionalLinkedHashMap(4);
        }
        this.lookedUpEntries.put(key, e);
    }

    public boolean isReadOnly() {
        return !(this.modifications != null && !this.modifications.isEmpty() || this.lookedUpEntries != null && !this.lookedUpEntries.isEmpty());
    }

    public abstract boolean isEnlisted();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransaction that = (LocalTransaction)o;
        return this.tx.getId() == that.tx.getId();
    }

    public int hashCode() {
        long id = this.tx.getId();
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        return "LocalTransaction{remoteLockedNodes=" + this.remoteLockedNodes + ", isMarkedForRollback=" + this.isMarkedForRollback + ", transaction=" + this.transaction + ", lockedKeys=" + this.lockedKeys + ", backupKeyLocks=" + this.backupKeyLocks + ", viewId=" + this.viewId + "} " + super.toString();
    }

    public void setModifications(List<WriteCommand> modifications) {
        this.modifications = modifications;
    }
}

