/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.BehaviorListener;

public class BehaviorBase
implements Behavior,
PartialStateHolder {
    private List<BehaviorListener> listeners;
    private boolean transientFlag = false;
    private boolean initialState = false;

    @Override
    public void broadcast(BehaviorEvent event) throws AbortProcessingException {
        if (null != this.listeners) {
            for (BehaviorListener listener : this.listeners) {
                if (!event.isAppropriateListener(listener)) continue;
                event.processListener(listener);
            }
        }
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.initialStateMarked()) {
            return null;
        }
        return UIComponentBase.saveAttachedState(context, this.listeners);
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            this.listeners = (List)UIComponentBase.restoreAttachedState(context, state);
            this.clearInitialState();
        }
    }

    @Override
    public void markInitialState() {
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        this.initialState = false;
    }

    protected void addBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<BehaviorListener>();
        }
        this.listeners.add(listener);
        this.clearInitialState();
    }

    protected void removeBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        this.clearInitialState();
    }
}

