/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.testing.OSGiBundle;

public class OSGiRuntimeHelper {
    private static final Logger log = Logger.getLogger(OSGiRuntimeHelper.class);
    private OSGiBootstrapProvider bootProvider;
    private boolean skipBootstrap;

    public OSGiBootstrapProvider getBootstrapProvider() {
        if (this.bootProvider == null && !this.skipBootstrap) {
            try {
                this.bootProvider = OSGiBootstrap.getBootstrapProvider();
            }
            catch (RuntimeException rte) {
                this.skipBootstrap = true;
                throw rte;
            }
        }
        return this.bootProvider;
    }

    public void ungetBootstrapProvider() {
        this.bootProvider = null;
    }

    public static void failsafeStop(OSGiBundle bundle) {
        if (bundle != null) {
            try {
                bundle.stop();
            }
            catch (Exception ex) {
                log.warn((Object)("Cannot stop bundle: " + bundle), (Throwable)ex);
            }
        }
    }

    public static void failsafeUninstall(OSGiBundle bundle) {
        if (bundle != null) {
            try {
                if (bundle.getState() != 1) {
                    bundle.uninstall();
                }
            }
            catch (Exception ex) {
                log.warn((Object)("Cannot uninstall bundle: " + bundle), (Throwable)ex);
            }
        }
    }
}

