/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Buffer;
import org.jgroups.util.Headers;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Message
implements Streamable {
    protected Address dest_addr;
    protected Address src_addr;
    private byte[] buf;
    protected int offset;
    protected int length;
    protected Headers headers;
    private volatile byte flags;
    private volatile byte transient_flags;
    protected static final Log log = LogFactory.getLog(Message.class);
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    public static final byte OOB = 1;
    public static final byte DONT_BUNDLE = 2;
    public static final byte NO_FC = 4;
    public static final byte SCOPED = 8;
    public static final byte NO_RELIABILITY = 16;
    public static final byte NO_TOTAL_ORDER = 32;
    public static final byte NO_RELAY = 64;
    public static final byte OOB_DELIVERED = 1;

    public Message(Address dest) {
        this.setDest(dest);
        this.headers = Message.createHeaders(3);
    }

    public Message(Address dest, Address src, byte[] buf) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf);
    }

    public Message(Address dest, byte[] buf) {
        this(dest, (Address)null, buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, byte[] buf, int offset, int length) {
        this(dest, null, buf, offset, length);
    }

    public Message(Address dest, Address src, Object obj) {
        this(dest);
        this.setSrc(src);
        this.setObject(obj);
    }

    public Message(Address dest, Object obj) {
        this(dest, null, obj);
    }

    public Message() {
        this.headers = Message.createHeaders(3);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = Message.createHeaders(3);
        }
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public final byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public final void setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public final void setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public final void setBuffer(Buffer buf) {
        if (buf != null) {
            this.buf = buf.getBuf();
            this.offset = buf.getOffset();
            this.length = buf.getLength();
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map<Short, Header> getHeaders() {
        return this.headers.getHeaders();
    }

    public String printHeaders() {
        return this.headers.printHeaders();
    }

    public int getNumHeaders() {
        return this.headers.size();
    }

    public final void setObject(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Buffer) {
            this.setBuffer((Buffer)obj);
            return;
        }
        try {
            byte[] tmp = Util.objectToByteBuffer(obj);
            this.setBuffer(tmp);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public final Object getObject() {
        try {
            return Util.objectFromByteBuffer(this.buf, this.offset, this.length);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.flags = (byte)(this.flags | flag);
    }

    public void clearFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.flags = (byte)(this.flags & ~flag);
    }

    public boolean isFlagSet(byte flag) {
        return Message.isFlagSet(this.flags, flag);
    }

    public void setTransientFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.transient_flags = (byte)(this.transient_flags | flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransientFlagIfAbsent(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        Message message = this;
        synchronized (message) {
            if (this.isTransientFlagSet(flag)) {
                return false;
            }
            this.setTransientFlag(flag);
            return true;
        }
    }

    public void clearTransientFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.transient_flags = (byte)(this.transient_flags & ~flag);
    }

    public boolean isTransientFlagSet(byte flag) {
        return Message.isFlagSet(this.transient_flags, flag);
    }

    protected static boolean isFlagSet(byte flags, byte flag) {
        return (flags & flag) == flag;
    }

    public byte getFlags() {
        return this.flags;
    }

    public byte getTransientFlags() {
        return this.transient_flags;
    }

    public void setScope(short scope) {
        Util.setScope(this, scope);
    }

    public short getScope() {
        return Util.getScope(this);
    }

    public void putHeader(short id, Header hdr) {
        if (id < 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        this.headers.putHeader(id, hdr);
    }

    public Header putHeaderIfAbsent(short id, Header hdr) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        return this.headers.putHeaderIfAbsent(id, hdr);
    }

    public Header getHeader(short id) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid. Add the protocol which calls " + "getHeader() to jg-protocol-ids.xml");
        }
        return this.headers.getHeader(id);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        return this.copy(copy_buffer, true);
    }

    public Message copy(boolean copy_buffer, boolean copy_headers) {
        Message retval = new Message(false);
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        retval.flags = this.flags;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = copy_headers ? Message.createHeaders(this.headers) : Message.createHeaders(3);
        return retval;
    }

    public Message copy(boolean copy_buffer, short starting_id) {
        Message retval = this.copy(copy_buffer, false);
        if (starting_id > 0) {
            for (Map.Entry<Short, Header> entry : this.getHeaders().entrySet()) {
                short id = entry.getKey();
                if (id < starting_id) continue;
                retval.putHeader(id, entry.getValue());
            }
        }
        return retval;
    }

    public Message makeReply() {
        return new Message(this.src_addr);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        int size = this.getNumHeaders();
        if (size > 0) {
            ret.append(" (").append(size).append(" headers)");
        }
        ret.append(", size=");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        if (this.flags > 0) {
            ret.append(", flags=").append(Message.flagsToString(this.flags));
        }
        if (this.transient_flags > 0) {
            ret.append(", transient_flags=" + Message.transientFlagsToString(this.transient_flags));
        }
        ret.append(']');
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String printObjectHeaders() {
        return this.headers.printObjectHeaders();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        byte leading = 0;
        if (this.dest_addr != null) {
            leading = Util.setFlag(leading, (byte)1);
        }
        if (this.src_addr != null) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.write(this.flags);
        if (this.dest_addr != null) {
            Util.writeAddress(this.dest_addr, out);
        }
        if (this.src_addr != null) {
            Util.writeAddress(this.src_addr, out);
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size = this.headers.size();
        out.writeShort(size);
        short[] ids = this.headers.getRawIDs();
        Header[] hdrs = this.headers.getRawHeaders();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] <= 0) continue;
            out.writeShort(ids[i]);
            Message.writeHeader(hdrs[i], out);
        }
    }

    public void writeToNoAddrs(Address src, DataOutputStream out) throws Exception {
        boolean write_src_addr;
        byte leading = 0;
        boolean bl = write_src_addr = src == null || this.src_addr != null && !this.src_addr.equals(src);
        if (write_src_addr) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.write(this.flags);
        if (write_src_addr) {
            Util.writeAddress(this.src_addr, out);
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size = this.headers.size();
        out.writeShort(size);
        short[] ids = this.headers.getRawIDs();
        Header[] hdrs = this.headers.getRawHeaders();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] <= 0) continue;
            out.writeShort(ids[i]);
            Message.writeHeader(hdrs[i], out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        int len;
        byte leading = in.readByte();
        this.flags = in.readByte();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.src_addr = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)4)) {
            len = in.readInt();
            this.buf = new byte[len];
            in.readFully(this.buf, 0, len);
            this.length = len;
        }
        len = in.readShort();
        this.headers = Message.createHeaders(len);
        short[] ids = this.headers.getRawIDs();
        Header[] hdrs = this.headers.getRawHeaders();
        for (int i = 0; i < len; ++i) {
            short id = in.readShort();
            Header hdr = Message.readHeader(in);
            ids[i] = id;
            hdrs[i] = hdr;
        }
    }

    public long size() {
        long retval = 2L;
        if (this.dest_addr != null) {
            retval += (long)Util.size(this.dest_addr);
        }
        if (this.src_addr != null) {
            retval += (long)Util.size(this.src_addr);
        }
        if (this.buf != null) {
            retval += (long)(4 + this.length);
        }
        retval += 2L;
        return retval += (long)this.headers.marshalledSize();
    }

    public static String flagsToString(byte flags) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (Message.isFlagSet(flags, (byte)1)) {
            first = false;
            sb.append("OOB");
        }
        if (Message.isFlagSet(flags, (byte)2)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("DONT_BUNDLE");
        }
        if (Message.isFlagSet(flags, (byte)4)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_FC");
        }
        if (Message.isFlagSet(flags, (byte)8)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("SCOPED");
        }
        if (Message.isFlagSet(flags, (byte)16)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_RELIABILITY");
        }
        if (Message.isFlagSet(flags, (byte)32)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_TOTAL_ORDER");
        }
        if (Message.isFlagSet(flags, (byte)64)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("NO_RELAY");
        }
        return sb.toString();
    }

    public static String transientFlagsToString(byte flags) {
        StringBuilder sb = new StringBuilder();
        if (Message.isFlagSet(flags, (byte)1)) {
            sb.append("OOB_DELIVERED");
        }
        return sb.toString();
    }

    private static void writeHeader(Header hdr, DataOutput out) throws Exception {
        short magic_number = ClassConfigurator.getMagicNumber(hdr.getClass());
        out.writeShort(magic_number);
        hdr.writeTo(out);
    }

    private static Header readHeader(DataInput in) throws Exception {
        short magic_number = in.readShort();
        Class<Address> clazz = ClassConfigurator.get(magic_number);
        if (clazz == null) {
            throw new IllegalArgumentException("magic number " + magic_number + " is not available in magic map");
        }
        Header hdr = (Header)((Object)clazz.newInstance());
        hdr.readFrom(in);
        return hdr;
    }

    private static Headers createHeaders(int size) {
        return size > 0 ? new Headers(size) : new Headers(3);
    }

    private static Headers createHeaders(Headers m) {
        return new Headers(m);
    }
}

