/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class GroupRequest<T>
extends Request {
    private final Map<Address, Rsp<T>> requests;
    int num_valid;
    int num_received;
    int num_suspected;

    public GroupRequest(Message msg, RequestCorrelator corr, Collection<Address> targets, RequestOptions options) {
        super(msg, corr, options);
        int size = targets.size();
        this.requests = new HashMap<Address, Rsp<T>>(size);
        this.setTargets(targets);
    }

    public GroupRequest(Message msg, RequestCorrelator corr, Address target, RequestOptions options) {
        super(msg, corr, options);
        this.requests = new HashMap<Address, Rsp<T>>(1);
        this.setTarget(target);
    }

    public boolean getAnycasting() {
        return this.options.getAnycasting();
    }

    public void setAnycasting(boolean anycasting) {
        this.options.setAnycasting(anycasting);
    }

    @Override
    public void sendRequest() throws Exception {
        this.sendRequest(this.requests.keySet(), this.req_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender, boolean is_exception) {
        if (this.done) {
            return;
        }
        Rsp<Object> rsp = this.requests.get(sender);
        if (rsp == null) {
            return;
        }
        RspFilter rsp_filter = this.options.getRspFilter();
        boolean responseReceived = false;
        this.lock.lock();
        try {
            if (!rsp.wasReceived()) {
                ++this.num_received;
                responseReceived = rsp_filter == null || rsp_filter.isAcceptable(response_value, sender);
                if (responseReceived) {
                    if (is_exception && response_value instanceof Throwable) {
                        rsp.setException((Throwable)response_value);
                    } else {
                        rsp.setValue(response_value);
                    }
                    rsp.setReceived(true);
                    ++this.num_valid;
                }
            }
            boolean bl = this.done = this.responsesComplete() || rsp_filter != null && !rsp_filter.needMoreResponses();
            if (responseReceived || this.done) {
                this.completed.signalAll();
            }
            if (this.done && this.corr != null) {
                this.corr.done(this.req_id);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (responseReceived || this.done) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null) {
            return;
        }
        boolean changed = false;
        Rsp<T> rsp = this.requests.get(suspected_member);
        if (rsp != null && rsp.setSuspected(true)) {
            rsp.setValue(null);
            changed = true;
            this.lock.lock();
            try {
                ++this.num_suspected;
                this.completed.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View new_view) {
        List<Address> mbrs;
        List<Address> list = mbrs = new_view != null ? new_view.getMembers() : null;
        if (mbrs == null) {
            return;
        }
        boolean changed = false;
        if (this.requests == null || this.requests.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                if (mbrs.contains(mbr)) continue;
                Rsp<T> rsp = entry.getValue();
                rsp.setValue(null);
                if (!rsp.setSuspected(true)) continue;
                ++this.num_suspected;
                changed = true;
            }
            if (changed) {
                this.completed.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    public RspList<T> getResults() {
        Collection<Rsp<T>> rsps = this.requests.values();
        return new RspList<T>(rsps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList<T> get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            this.waitForResults(0L);
        }
        finally {
            this.lock.unlock();
        }
        return this.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ok;
        this.lock.lock();
        try {
            ok = this.waitForResults(unit.toMillis(timeout));
        }
        finally {
            this.lock.unlock();
        }
        if (!ok) {
            throw new TimeoutException();
        }
        return this.getResults();
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        if (!this.requests.isEmpty()) {
            ret.append(", entries:\n");
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                Rsp<T> rsp = entry.getValue();
                ret.append(mbr).append(": ").append(rsp).append("\n");
            }
        }
        return ret.toString();
    }

    private void setTarget(Address mbr) {
        this.requests.put(mbr, new Rsp(mbr));
    }

    private void setTargets(Collection<Address> mbrs) {
        for (Address mbr : mbrs) {
            this.requests.put(mbr, new Rsp(mbr));
        }
    }

    private static int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private void sendRequest(Collection<Address> targetMembers, long requestId) throws Exception {
        try {
            this.corr.sendRequest(requestId, targetMembers, this.request_msg, this.options.getMode() == ResponseMode.GET_NONE ? null : this, this.options);
        }
        catch (Exception ex) {
            if (this.corr != null) {
                this.corr.done(requestId);
            }
            throw ex;
        }
    }

    @Override
    protected boolean responsesComplete() {
        if (this.done) {
            return true;
        }
        int num_total = this.requests.size();
        switch (this.options.getMode()) {
            case GET_FIRST: {
                return this.num_valid >= 1 || this.num_suspected >= num_total || this.num_received >= num_total;
            }
            case GET_ALL: {
                return this.num_valid + this.num_suspected >= num_total || this.num_received >= num_total;
            }
            case GET_MAJORITY: {
                int majority = GroupRequest.determineMajority(num_total);
                return this.num_valid + this.num_suspected >= majority || this.num_received >= num_total;
            }
            case GET_NONE: {
                return true;
            }
        }
        if (log.isErrorEnabled()) {
            log.error("rsp_mode " + (Object)((Object)this.options.getMode()) + " unknown !");
        }
        return false;
    }
}

