/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.management;

import java.io.IOException;
import org.jboss.as.controller.remote.ManagementOperationHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelFactory;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.remoting.AbstractChannelOpenListenerService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.xnio.OptionMap;

class ManagementChannelOpenListenerService
extends AbstractChannelOpenListenerService<ManagementChannel> {
    private final InjectedValue<ManagementOperationHandlerFactory> operationHandlerFactoryValue = new InjectedValue();

    ManagementChannelOpenListenerService(String channelName, OptionMap optionMap) {
        super(channelName, optionMap);
    }

    public InjectedValue<ManagementOperationHandlerFactory> getOperationHandlerInjector() {
        return this.operationHandlerFactoryValue;
    }

    @Override
    protected ManagementChannel createChannel(Channel channel) {
        ManagementOperationHandler handler = ((ManagementOperationHandlerFactory)this.operationHandlerFactoryValue.getValue()).createOperationHandler();
        final ManagementChannel managementChannel = new ManagementChannelFactory(handler).create(this.channelName, channel);
        this.log.tracef("Opened %s: %s with handler %s", (Object)this.channelName, (Object)managementChannel, (Object)handler);
        managementChannel.startReceiving();
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                try {
                    managementChannel.sendByeBye();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ManagementChannelOpenListenerService.this.log.tracef("Handling close for %s", (Object)managementChannel);
            }
        });
        return managementChannel;
    }

    @Override
    protected void closeChannelOnShutdown(ManagementChannel channel) {
        try {
            channel.sendByeBye();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

