/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata.internal;

import java.util.Collections;
import java.util.Map;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.metadata.internal.AbstractAttributeAware;

public class AbstractParameterizedAttribute
extends AbstractAttributeAware
implements ParameterizedAttribute {
    private static final long serialVersionUID = 1L;
    protected Map<String, Parameter> attributes;
    protected Map<String, Parameter> directives;

    public AbstractParameterizedAttribute(String attribute, Map<String, Parameter> attributes, Map<String, Parameter> directives) {
        super(attribute);
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        this.attributes = attributes;
        if (directives == null) {
            directives = Collections.emptyMap();
        }
        this.directives = directives;
    }

    @Override
    public Map<String, Parameter> getAttributes() {
        return this.attributes;
    }

    @Override
    public Parameter getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public <T> T getAttributeValue(String name, Class<T> type) {
        return this.getAttributeValue(name, null, type);
    }

    @Override
    public <T> T getAttributeValue(String name, T defaultValue, Class<T> type) {
        Parameter parameter = this.getAttribute(name);
        if (parameter == null) {
            return defaultValue;
        }
        if (parameter.isCollection()) {
            throw new IllegalArgumentException("Duplicate " + name + " attribute.");
        }
        Object value = parameter.getValue();
        if (value == null) {
            return defaultValue;
        }
        return type.cast(value);
    }

    @Override
    public Map<String, Parameter> getDirectives() {
        return this.directives;
    }

    @Override
    public Parameter getDirective(String name) {
        return this.directives.get(name);
    }

    @Override
    public <T> T getDirectiveValue(String name, Class<T> type) {
        return this.getDirectiveValue(name, null, type);
    }

    @Override
    public <T> T getDirectiveValue(String name, T defaultValue, Class<T> type) {
        Parameter parameter = this.getDirective(name);
        if (parameter == null) {
            return defaultValue;
        }
        if (parameter.isCollection()) {
            throw new IllegalArgumentException("Duplicate " + name + " directive.");
        }
        Object value = parameter.getValue();
        if (value == null) {
            return defaultValue;
        }
        return type.cast(value);
    }
}

