/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.management.ManagementService;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CoreAddressResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class HornetQServerResource
implements Resource {
    private final Resource delegate;
    private ServiceController<HornetQServer> hornetQServerServiceController;

    public HornetQServerResource() {
        this(Resource.Factory.create());
    }

    public HornetQServerResource(Resource delegate) {
        this.delegate = delegate;
    }

    public ServiceController<HornetQServer> getHornetQServerServiceController() {
        return this.hornetQServerServiceController;
    }

    public void setHornetQServerServiceController(ServiceController<HornetQServer> hornetQServerServiceController) {
        this.hornetQServerServiceController = hornetQServerServiceController;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("core-address".equals(element.getKey())) {
            return this.hasAddressControl(element);
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("core-address".equals(element.getKey())) {
            return this.hasAddressControl(element) ? CoreAddressResource.INSTANCE : null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("core-address".equals(element.getKey())) {
            if (this.hasAddressControl(element)) {
                return CoreAddressResource.INSTANCE;
            }
            throw new NoSuchElementException(element.toString());
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("core-address".equals(childType)) {
            return this.getChildrenNames("core-address").size() > 0;
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "core-address".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new NoSuchElementException(address.subAddress(1).toString());
            }
            return CoreAddressResource.INSTANCE;
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>(this.delegate.getChildTypes());
        result.add("core-address");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("core-address".equals(childType)) {
            return this.getCoreAddressNames();
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("core-address".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getCoreAddressNames()) {
                result.add(new CoreAddressResource.CoreAddressResourceEntry(name));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        if ("core-address".equals(address.getKey())) {
            throw new UnsupportedOperationException(String.format("Resources of type %s cannot be registered", "core-address"));
        }
        this.delegate.registerChild(address, resource);
    }

    public Resource removeChild(PathElement address) {
        if ("core-address".equals(address.getKey())) {
            throw new UnsupportedOperationException(String.format("Resources of type %s cannot be removed", "core-address"));
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        HornetQServerResource clone = new HornetQServerResource(this.delegate.clone());
        clone.setHornetQServerServiceController(this.hornetQServerServiceController);
        return clone;
    }

    private boolean hasAddressControl(PathElement element) {
        ManagementService managementService = this.getManagementService();
        return managementService == null ? false : managementService.getResource("core.address." + element.getValue()) != null;
    }

    private Set<String> getCoreAddressNames() {
        ManagementService managementService = this.getManagementService();
        if (managementService == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Object obj : managementService.getResources(AddressControl.class)) {
            AddressControl ac = (AddressControl)AddressControl.class.cast(obj);
            result.add(ac.getAddress());
        }
        return result;
    }

    private ManagementService getManagementService() {
        if (this.hornetQServerServiceController == null || this.hornetQServerServiceController.getState() != ServiceController.State.UP) {
            return null;
        }
        return ((HornetQServer)this.hornetQServerServiceController.getValue()).getManagementService();
    }
}

