/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.util.Collections;
import java.util.List;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.JAXRPCDeployment;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.webserviceref.WSReferences;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;

public final class ASHelper {
    private ASHelper() {
    }

    public static List<EJBEndpoint> getJaxwsEjbs(DeploymentUnit unit) {
        JAXWSDeployment jaxwsDeployment = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        boolean hasEjbEndpoints = jaxwsDeployment != null ? jaxwsDeployment.getEjbEndpoints().size() > 0 : false;
        return hasEjbEndpoints ? jaxwsDeployment.getEjbEndpoints() : Collections.emptyList();
    }

    public static List<EJBEndpoint> getJaxrpcEjbs(DeploymentUnit unit) {
        JAXRPCDeployment jaxrpcDeployment = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JAXRPC_ENDPOINTS_KEY);
        boolean hasEjbEndpoints = jaxrpcDeployment != null ? jaxrpcDeployment.getEjbEndpoints().size() > 0 : false;
        return hasEjbEndpoints ? jaxrpcDeployment.getEjbEndpoints() : Collections.emptyList();
    }

    public static List<POJOEndpoint> getJaxwsPojos(DeploymentUnit unit) {
        JAXWSDeployment jaxwsDeployment = (JAXWSDeployment)unit.getAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        boolean hasPojoEndpoints = jaxwsDeployment != null ? jaxwsDeployment.getPojoEndpoints().size() > 0 : false;
        return hasPojoEndpoints ? jaxwsDeployment.getPojoEndpoints() : Collections.emptyList();
    }

    public static List<POJOEndpoint> getJaxrpcPojos(DeploymentUnit unit) {
        JAXRPCDeployment jaxrpcDeployment = (JAXRPCDeployment)unit.getAttachment(WSAttachmentKeys.JAXRPC_ENDPOINTS_KEY);
        boolean hasPojoEndpoints = jaxrpcDeployment != null ? jaxrpcDeployment.getPojoEndpoints().size() > 0 : false;
        return hasPojoEndpoints ? jaxrpcDeployment.getPojoEndpoints() : Collections.emptyList();
    }

    public static String getEndpointName(ServletMetaData servletMD) {
        String endpointName = servletMD.getName();
        return endpointName != null ? endpointName.trim() : null;
    }

    public static String getEndpointClassName(ServletMetaData servletMD) {
        String endpointClass = servletMD.getServletClass();
        return endpointClass != null ? endpointClass.trim() : null;
    }

    public static ServletMetaData getServletForName(JBossWebMetaData jbossWebMD, String servletName) {
        for (JBossServletMetaData servlet : jbossWebMD.getServlets()) {
            if (!servlet.getName().equals(servletName)) continue;
            return servlet;
        }
        return null;
    }

    public static <A> A getRequiredAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        Object value = unit.getAttachment(key);
        if (value == null) {
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        return (A)unit.getAttachment(key);
    }

    public static boolean isJaxwsService(ClassInfo current, CompositeIndex index) {
        ClassInfo tmp = current;
        while (tmp != null) {
            DotName superName = tmp.superName();
            if (DotNames.JAXWS_SERVICE_CLASS.equals((Object)superName)) {
                return true;
            }
            tmp = index.getClassByName(superName);
        }
        return false;
    }

    public static boolean isJaxwsService(ClassInfo current, Index index) {
        ClassInfo tmp = current;
        while (tmp != null) {
            DotName superName = tmp.superName();
            if (DotNames.JAXWS_SERVICE_CLASS.equals((Object)superName)) {
                return true;
            }
            tmp = index.getClassByName(superName);
        }
        return false;
    }

    public static JBossWebMetaData getJBossWebMetaData(DeploymentUnit unit) {
        WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData result = null;
        if (warMetaData != null) {
            result = warMetaData.getMergedJBossWebMetaData();
            if (result == null) {
                result = warMetaData.getJbossWebMetaData();
            }
        } else {
            result = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JBOSSWEB_METADATA_KEY);
        }
        return result;
    }

    public static List<AnnotationInstance> getAnnotations(DeploymentUnit unit, DotName annotation) {
        CompositeIndex compositeIndex = (CompositeIndex)ASHelper.getRequiredAttachment(unit, Attachments.COMPOSITE_ANNOTATION_INDEX);
        return compositeIndex.getAnnotations(annotation);
    }

    public static JAXWSDeployment getJaxwsDeployment(DeploymentUnit unit) {
        JAXWSDeployment wsDeployment = (JAXWSDeployment)unit.getAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        if (wsDeployment == null) {
            wsDeployment = new JAXWSDeployment();
            unit.putAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY, (Object)wsDeployment);
        }
        return wsDeployment;
    }

    public static JAXRPCDeployment getJaxrpcDeployment(DeploymentUnit unit) {
        JAXRPCDeployment wsDeployment = (JAXRPCDeployment)unit.getAttachment(WSAttachmentKeys.JAXRPC_ENDPOINTS_KEY);
        if (wsDeployment == null) {
            wsDeployment = new JAXRPCDeployment();
            unit.putAttachment(WSAttachmentKeys.JAXRPC_ENDPOINTS_KEY, (Object)wsDeployment);
        }
        return wsDeployment;
    }

    public static WSReferences getWSRefRegistry(DeploymentUnit unit) {
        WSReferences refRegistry = (WSReferences)unit.getAttachment(WSAttachmentKeys.WS_REFERENCES);
        if (refRegistry == null) {
            refRegistry = WSReferences.newInstance();
            unit.putAttachment(WSAttachmentKeys.WS_REFERENCES, (Object)refRegistry);
        }
        return refRegistry;
    }

    public static String getContextRoot(Deployment dep, JBossWebMetaData jbossWebMD) {
        ModuleMetaData moduleMD;
        DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
        JBossAppMetaData jbossAppMD = unit.getParent() == null ? null : ASHelper.getOptionalAttachment(unit.getParent(), WSAttachmentKeys.JBOSS_APP_METADATA_KEY);
        String contextRoot = null;
        if (jbossAppMD != null && (moduleMD = jbossAppMD.getModule(dep.getSimpleName())) != null) {
            WebModuleMetaData webModuleMD = (WebModuleMetaData)moduleMD.getValue();
            contextRoot = webModuleMD.getContextRoot();
        }
        if (contextRoot == null) {
            contextRoot = jbossWebMD != null ? jbossWebMD.getContextRoot() : null;
        }
        return contextRoot;
    }
}

