/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class CompilationMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static CompilationMXBeanAttributeHandler INSTANCE = new CompilationMXBeanAttributeHandler();

    private CompilationMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name) || PlatformMBeanConstants.COMPILATION_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.COMPILATION_METRICS.contains(name))) {
                throw CompilationMXBeanAttributeHandler.unknownAttribute(operation);
            }
            CompilationMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    static void storeResult(String attributeName, ModelNode store) throws OperationFailedException {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(attributeName)) {
            store.set("java.lang:type=Compilation");
        } else if ("name".equals(attributeName)) {
            store.set(ManagementFactory.getCompilationMXBean().getName());
        } else if ("compilation-time-monitoring-supported".equals(attributeName)) {
            store.set(ManagementFactory.getCompilationMXBean().isCompilationTimeMonitoringSupported());
        } else if ("total-compilation-time".equals(attributeName)) {
            store.set(ManagementFactory.getCompilationMXBean().getTotalCompilationTime());
        } else if (PlatformMBeanConstants.COMPILATION_READ_ATTRIBUTES.contains(attributeName) || PlatformMBeanConstants.COMPILATION_METRICS.contains(attributeName)) {
            throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", attributeName));
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw CompilationMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.COMPILATION_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.COMPILATION_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }
}

