/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.deployment.BundleStartTracker;
import org.jboss.as.osgi.deployment.OSGiDeploymentActivator;
import org.jboss.as.osgi.parser.OSGiRuntimeResource;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.BundleInstallProviderIntegration;
import org.jboss.as.osgi.service.ConfigAdminServiceImpl;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.Bundle;

class OSGiSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final OSGiSubsystemAdd INSTANCE = new OSGiSubsystemAdd();
    private OSGiRuntimeResource resource;
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("operation-name").set("add");
            node.get("description").set(resbundle.getString("subsystem.add"));
            node.get(new String[]{"request-properties", "activation", "description"}).set(resbundle.getString("subsystem.activation"));
            node.get(new String[]{"request-properties", "activation", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "activation", "default"}).set(SubsystemState.DEFAULT_ACTIVATION.toString());
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private OSGiSubsystemAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.resource = new OSGiRuntimeResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)this.resource);
        this.populateModel(operation, this.resource);
        final ModelNode model = this.resource.getModel();
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    OSGiSubsystemAdd.this.performRuntime(context, operation, model, verificationHandler, controllers);
                    if (OSGiSubsystemAdd.this.requiresRuntimeVerification()) {
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    }
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        OSGiSubsystemAdd.this.rollbackRuntime(context, operation, model, controllers);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        if (operation.has("activation")) {
            model.get("activation").set(operation.get("activation"));
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        OSGiLogger.ROOT_LOGGER.activatingSubsystem();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(BundleStartTracker.addService(serviceTarget));
                newControllers.add(BundleInstallProviderIntegration.addService(serviceTarget));
                newControllers.add(FrameworkBootstrapService.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
                newControllers.add(ConfigAdminServiceImpl.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                new OSGiDeploymentActivator().activate(processorTarget);
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget serviceTarget = context.getServiceTarget();
        newControllers.add(SubsystemState.addService(serviceTarget, this.getActivationMode(operation)));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceBuilder builder = context.getServiceTarget().addService(Services.JBOSGI_BASE_NAME.append(new String[]{"OSGiSubsystem"}).append(new String[]{"initialize"}), (Service)new AbstractService<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void start(StartContext context) throws StartException {
                        try {
                            ServiceContainer ctr = context.getController().getServiceContainer();
                            ServiceController sc = ctr.getRequiredService(Services.SYSTEM_BUNDLE);
                            OSGiSubsystemAdd.this.resource.setBundleContextServiceController((ServiceController<Bundle>)sc);
                        }
                        finally {
                            context.getController().setMode(ServiceController.Mode.REMOVE);
                        }
                    }
                });
                builder.addDependency(Services.SYSTEM_BUNDLE);
                builder.setInitialMode(ServiceController.Mode.PASSIVE);
                builder.install();
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        OSGiLogger.ROOT_LOGGER.debugf("Activated OSGi Subsystem", new Object[0]);
    }

    private SubsystemState.Activation getActivationMode(ModelNode operation) {
        SubsystemState.Activation activation = SubsystemState.DEFAULT_ACTIVATION;
        if (operation.has("activation")) {
            activation = SubsystemState.Activation.valueOf(operation.get("activation").asString().toUpperCase());
        }
        return activation;
    }
}

