/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.FinderException;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.jdbc.JDBCCommandFactory;
import org.jboss.as.cmp.jdbc.JDBCCustomFinderQuery;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.QLCompiler;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCAutomaticQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQlQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.logging.Logger;

public final class JDBCQueryManager {
    private static final String FIND_BY_PK = "findByPrimaryKey";
    private static final String EJB_FIND = "ejbFind";
    private static final String FIND_ALL = "findAll";
    private static final String FIND_BY = "findBy";
    private final Map knownQueries = new HashMap();
    private final JDBCStoreManager manager;

    public JDBCQueryManager(JDBCStoreManager manager) {
        this.manager = manager;
    }

    public static QLCompiler getInstance(Class impl, Catalog catalog) {
        Constructor constructor;
        if (impl == null) {
            throw new RuntimeException("ql-compiler is not specified.");
        }
        try {
            constructor = impl.getConstructor(Catalog.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Compiler class does not have a constructor which takes " + Catalog.class.getName());
        }
        try {
            return (QLCompiler)constructor.newInstance(catalog);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create an instance of " + impl.getName() + ": " + e.getMessage(), e);
        }
    }

    public JDBCQueryCommand getQueryCommand(Method queryMethod) throws FinderException {
        JDBCQueryCommand queryCommand = (JDBCQueryCommand)this.knownQueries.get(queryMethod);
        if (queryCommand == null) {
            throw new FinderException("Unknown query: " + queryMethod);
        }
        return queryCommand;
    }

    public void start() {
        JDBCQueryMetaData q2;
        JDBCReadAheadMetaData readAhead;
        JDBCQueryMetaData findByPKMD;
        Method method;
        Logger log = Logger.getLogger((String)(this.getClass().getName() + "." + this.manager.getMetaData().getName()));
        JDBCCommandFactory factory = this.manager.getCommandFactory();
        Class homeClass = this.manager.getComponent().getHomeClass();
        Class localHomeClass = this.manager.getComponent().getLocalHomeClass();
        JDBCEntityBridge entity = (JDBCEntityBridge)this.manager.getEntityBridge();
        if (homeClass != null) {
            try {
                method = homeClass.getMethod(FIND_BY_PK, entity.getPrimaryKeyClass());
                findByPKMD = this.manager.getMetaData().getQueryMetaDataForMethod(method);
                readAhead = findByPKMD == null ? entity.getMetaData().getReadAhead() : findByPKMD.getReadAhead();
                q2 = new JDBCAutomaticQueryMetaData(method, readAhead, entity.getMetaData().getQlCompiler(), false);
                this.knownQueries.put(method, factory.createFindByPrimaryKeyQuery(q2));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Added findByPrimaryKey query command for home interface");
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Home interface does not have a findByPrimaryKey method");
            }
        }
        if (localHomeClass != null) {
            try {
                method = localHomeClass.getMethod(FIND_BY_PK, entity.getPrimaryKeyClass());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Local home interface does not have the method findByPrimaryKey(" + entity.getPrimaryKeyClass().getName() + ")");
            }
            findByPKMD = this.manager.getMetaData().getQueryMetaDataForMethod(method);
            readAhead = findByPKMD == null ? entity.getMetaData().getReadAhead() : findByPKMD.getReadAhead();
            q2 = new JDBCAutomaticQueryMetaData(method, readAhead, entity.getMetaData().getQlCompiler(), false);
            this.knownQueries.put(method, factory.createFindByPrimaryKeyQuery(q2));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Added findByPrimaryKey query command for local home interface");
            }
        }
        Class<?> ejbClass = this.manager.getMetaData().getEntityClass();
        Method[] customMethods = ejbClass.getMethods();
        for (int i = 0; i < customMethods.length; ++i) {
            Method interfaceMethod;
            Method m = customMethods[i];
            String methodName = m.getName();
            if (!methodName.startsWith(EJB_FIND)) continue;
            String interfaceName = 'f' + methodName.substring(4);
            if (homeClass != null) {
                try {
                    interfaceMethod = homeClass.getMethod(interfaceName, m.getParameterTypes());
                    this.knownQueries.put(interfaceMethod, new JDBCCustomFinderQuery(this.manager, m));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added custom finder " + methodName + " on home interface"));
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (localHomeClass == null) continue;
            try {
                interfaceMethod = localHomeClass.getMethod(interfaceName, m.getParameterTypes());
                this.knownQueries.put(interfaceMethod, new JDBCCustomFinderQuery(this.manager, m));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added custom finder " + methodName + " on local home interface"));
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (JDBCQueryMetaData q2 : this.manager.getMetaData().getQueries()) {
            if (this.knownQueries.containsKey(q2.getMethod())) continue;
            if (q2 instanceof JDBCJBossQLQueryMetaData) {
                this.knownQueries.put(q2.getMethod(), factory.createJBossQLQuery(q2));
                continue;
            }
            if (q2 instanceof JDBCDynamicQLQueryMetaData) {
                this.knownQueries.put(q2.getMethod(), factory.createDynamicQLQuery(q2));
                continue;
            }
            if (q2 instanceof JDBCDeclaredQueryMetaData) {
                this.knownQueries.put(q2.getMethod(), factory.createDeclaredSQLQuery(q2));
                continue;
            }
            if (!(q2 instanceof JDBCQlQueryMetaData)) continue;
            this.knownQueries.put(q2.getMethod(), factory.createEJBQLQuery(q2));
        }
        if (homeClass != null) {
            this.addAutomaticFinders(this.manager, homeClass.getMethods(), log);
        }
        if (localHomeClass != null) {
            this.addAutomaticFinders(this.manager, localHomeClass.getMethods(), log);
        }
    }

    public void clear() {
        this.knownQueries.clear();
    }

    private void addAutomaticFinders(JDBCStoreManager manager, Method[] homeMethods, Logger log) {
        JDBCCommandFactory factory = manager.getCommandFactory();
        JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
        for (int i = 0; i < homeMethods.length; ++i) {
            JDBCAutomaticQueryMetaData q;
            Method method = homeMethods[i];
            if (this.knownQueries.containsKey(method)) continue;
            String name = method.getName();
            if (name.equals(FIND_ALL)) {
                q = new JDBCAutomaticQueryMetaData(method, entity.getMetaData().getReadAhead(), entity.getMetaData().getQlCompiler(), false);
                this.knownQueries.put(method, factory.createFindAllQuery(q));
                continue;
            }
            if (!name.startsWith(FIND_BY) || name.equals(FIND_BY_PK)) continue;
            try {
                q = new JDBCAutomaticQueryMetaData(method, entity.getMetaData().getReadAhead(), entity.getMetaData().getQlCompiler(), false);
                this.knownQueries.put(method, factory.createFindByQuery(q));
                continue;
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("Could not create the finder " + name + ", because no matching CMP field was found."));
            }
        }
    }
}

