/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.logging.Logger;

public final class JDBCStopCommand {
    private final JDBCEntityPersistenceStore manager;
    private final JDBCAbstractEntityBridge entity;
    private final JDBCEntityMetaData entityMetaData;
    private final Logger log;

    public JDBCStopCommand(JDBCEntityPersistenceStore manager) {
        this.manager = manager;
        this.entity = manager.getEntityBridge();
        this.entityMetaData = this.entity.getMetaData();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    public boolean execute() {
        boolean dropped;
        boolean success = true;
        JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
            JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
            if (!relationMetaData.isTableMappingStyle() || relationMetaData.isTableDropped() || !relationMetaData.getRemoveTable()) continue;
            boolean dropped2 = this.dropTable(this.manager.getDataSource(relationMetaData.getDataSourceName()), cmrField.getQualifiedTableName());
            if (!dropped2) {
                success = false;
                continue;
            }
            relationMetaData.setTableDropped();
        }
        if (this.entityMetaData.getRemoveTable() && !(dropped = this.dropTable(this.entity.getDataSource(), this.entity.getQualifiedTableName()))) {
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dropTable(DataSource dataSource, String qualifiedTableName) {
        boolean success;
        Transaction oldTransaction;
        TransactionManager tm;
        Connection con;
        block22: {
            con = null;
            ResultSet rs = null;
            String schema = SQLUtil.getSchema(qualifiedTableName);
            String tableName = schema != null ? SQLUtil.getTableNameWithoutSchema(qualifiedTableName) : qualifiedTableName;
            con = dataSource.getConnection();
            DatabaseMetaData dmd = con.getMetaData();
            rs = dmd.getTables(con.getCatalog(), schema, tableName, null);
            if (rs.next()) {
                JDBCUtil.safeClose(rs);
            }
            boolean bl = true;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(con);
            return bl;
            JDBCUtil.safeClose(con);
            tm = this.manager.getComponent().getTransactionManager();
            oldTransaction = null;
            try {
                oldTransaction = tm.suspend();
            }
            catch (Exception e) {
                this.log.error((Object)("Could not suspend current transaction before drop table. '" + qualifiedTableName + "' will not be dropped."), (Throwable)e);
            }
            break block22;
            catch (SQLException e) {
                this.log.debug((Object)"Error getting database metadata for DROP TABLE command.  DROP TABLE will not be executed. ", (Throwable)e);
                boolean bl2 = true;
                return bl2;
            }
            finally {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(con);
            }
        }
        try {
            Statement statement = null;
            try {
                con = dataSource.getConnection();
                statement = con.createStatement();
                String sql = "DROP TABLE " + qualifiedTableName;
                this.log.debug((Object)("Executing SQL: " + sql));
                statement.executeUpdate(sql);
                success = true;
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            JDBCUtil.safeClose(statement);
            JDBCUtil.safeClose(con);
            return success;
        }
        catch (Exception e) {
            this.log.debug((Object)("Could not drop table " + qualifiedTableName + ": " + e.getMessage()));
            success = false;
            return success;
        }
        finally {
            try {
                if (oldTransaction != null) {
                    tm.resume(oldTransaction);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Could not reattach original transaction after drop table");
            }
        }
    }
}

