/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCOracleCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private String sequence;
    private int jdbcType;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
    }

    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        this.sequence = entityCommand.getAttribute("sequence");
        if (this.sequence == null) {
            throw new RuntimeException("Sequence must be specified");
        }
    }

    @Override
    protected void initInsertSQL() {
        this.jdbcType = this.pkField.getJDBCType().getJDBCTypes()[0];
        StringBuffer sql = new StringBuffer();
        sql.append("{call INSERT INTO ").append(this.entity.getQualifiedTableName());
        sql.append(" (");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(", ");
        SQLUtil.getColumnNamesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" VALUES (");
        sql.append(this.sequence + ".NEXTVAL, ");
        SQLUtil.getValuesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" RETURNING ");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(" INTO ? }");
        this.insertSQL = sql.toString();
        if (this.debug) {
            this.log.debug((Object)("Insert Entity SQL: " + this.insertSQL));
        }
    }

    @Override
    protected PreparedStatement prepareStatement(Connection c, String sql, CmpEntityBeanContext ctx) throws SQLException {
        return c.prepareCall(sql);
    }

    @Override
    protected int executeInsert(int paramIndex, PreparedStatement ps, CmpEntityBeanContext ctx) throws SQLException {
        CallableStatement cs = (CallableStatement)ps;
        cs.registerOutParameter(paramIndex, this.jdbcType);
        cs.execute();
        Object pk = JDBCUtil.getParameter(this.log, cs, paramIndex, this.jdbcType, this.pkField.getFieldType());
        this.pkField.setInstanceValue(ctx, pk);
        return 1;
    }
}

