/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ejb.FinderException;
import org.jboss.as.cmp.jdbc.EJBQLToSQL92Compiler;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.QueryParameter;
import org.jboss.as.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
import org.jboss.as.cmp.jdbc2.AbstractQueryCommand;
import org.jboss.as.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.as.cmp.jdbc2.QueryCommand;
import org.jboss.as.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.as.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.as.cmp.jdbc2.schema.Schema;
import org.jboss.logging.Logger;

public class DynamicQueryCommand
implements QueryCommand {
    private Logger log;
    private JDBCEntityBridge2 entity;
    private JDBCDynamicQLQueryMetaData metadata;
    private AbstractQueryCommand.CollectionFactory collectionFactory;

    public DynamicQueryCommand(JDBCEntityBridge2 entity, JDBCDynamicQLQueryMetaData metadata) {
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName()));
        this.entity = entity;
        this.metadata = metadata;
        Class<?> returnType = metadata.getMethod().getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            this.collectionFactory = Set.class.isAssignableFrom(returnType) ? AbstractQueryCommand.SET_FACTORY : AbstractQueryCommand.COLLECTION_FACTORY;
        }
    }

    @Override
    public JDBCStoreManager2 getStoreManager() {
        return (JDBCStoreManager2)this.entity.getManager();
    }

    @Override
    public Collection fetchCollection(Schema schema, Object[] args, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("executing dynamic-ql: " + args[0]));
        }
        JDBCStoreManager2 manager = (JDBCStoreManager2)this.entity.getManager();
        EJBQLToSQL92Compiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
        try {
            compiler.compileJBossQL((String)args[0], this.metadata.getMethod().getReturnType(), DynamicQueryCommand.getParamTypes(args), this.metadata);
        }
        catch (Throwable t) {
            this.log.error((Object)("Error compiling JBossQL statement '" + args[0] + "'"), t);
            throw new FinderException("Error compiling JBossQL statement '" + args[0] + "'");
        }
        String sql = compiler.getSQL();
        int offsetParam = compiler.getOffsetParam();
        int offsetValue = compiler.getOffsetValue();
        int limitParam = compiler.getLimitParam();
        int limitValue = compiler.getLimitValue();
        AbstractQueryCommand.ResultReader resultReader = !compiler.isSelectEntity() ? (compiler.isSelectField() ? new AbstractQueryCommand.FieldReader((JDBCCMPFieldBridge2)compiler.getSelectField()) : new AbstractQueryCommand.FunctionReader(compiler.getSelectFunction())) : new AbstractQueryCommand.EntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
        return AbstractQueryCommand.fetchCollection(this.entity, sql, DynamicQueryCommand.toArray(compiler.getInputParameters()), AbstractQueryCommand.toInt(args, offsetParam, offsetValue), AbstractQueryCommand.toInt(args, limitParam, limitValue), new AbstractQueryCommand.EagerCollectionStrategy(this.collectionFactory, resultReader, this.log), schema, (Object[])args[1], factory, this.log);
    }

    @Override
    public Object fetchOne(Schema schema, Object[] args, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("executing dynamic-ql: " + args[0]));
        }
        JDBCStoreManager2 manager = (JDBCStoreManager2)this.entity.getManager();
        EJBQLToSQL92Compiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
        try {
            compiler.compileJBossQL((String)args[0], this.metadata.getMethod().getReturnType(), DynamicQueryCommand.getParamTypes(args), this.metadata);
        }
        catch (Throwable t) {
            this.log.error((Object)("Error compiling JBossQL statement '" + args[0] + "'"), t);
            throw new FinderException("Error compiling JBossQL statement '" + args[0] + "'");
        }
        String sql = compiler.getSQL();
        AbstractQueryCommand.ResultReader resultReader = !compiler.isSelectEntity() ? (compiler.isSelectField() ? new AbstractQueryCommand.FieldReader((JDBCCMPFieldBridge2)compiler.getSelectField()) : new AbstractQueryCommand.FunctionReader(compiler.getSelectFunction())) : new AbstractQueryCommand.EntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
        return AbstractQueryCommand.fetchOne(this.entity, sql, DynamicQueryCommand.toArray(compiler.getInputParameters()), resultReader, (Object[])args[1], factory, this.log);
    }

    private static Class[] getParamTypes(Object[] args) throws FinderException {
        Class[] parameterTypes;
        Object[] parameters = (Object[])args[1];
        if (parameters == null) {
            parameterTypes = new Class[]{};
        } else {
            parameterTypes = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) {
                    throw new FinderException("Parameter[" + i + "] is null");
                }
                parameterTypes[i] = parameters[i].getClass();
            }
        }
        return parameterTypes;
    }

    static QueryParameter[] toArray(List p) {
        QueryParameter[] params = null;
        if (p.size() > 0) {
            params = p.toArray(new QueryParameter[p.size()]);
        }
        return params;
    }
}

