/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.processors;

import java.io.Closeable;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.JDBCMetaDataParser;
import org.jboss.as.cmp.processors.Attachments;
import org.jboss.as.cmp.processors.CmpDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.parser.util.NoopXmlResolver;
import org.jboss.modules.Module;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class CmpParsingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!CmpDeploymentMarker.isCmpDeployment(deploymentUnit)) {
            return;
        }
        EjbJarMetaData jarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (jarMetaData == null || jarMetaData.getEnterpriseBeans() == null) {
            throw new IllegalStateException("Deployment " + deploymentUnit + " illegally marked as a CMP deployment");
        }
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setXMLResolver(NoopXmlResolver.create());
        XMLStreamReader xmlReader = null;
        JDBCApplicationMetaData jdbcMetaData = new JDBCApplicationMetaData(jarMetaData, (ClassLoader)module.getClassLoader());
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream("standardjbosscmp-jdbc.xml");
            xmlReader = inputFactory.createXMLStreamReader(inputStream);
            jdbcMetaData = JDBCMetaDataParser.parse(xmlReader, jdbcMetaData);
        }
        catch (Exception e) {
            try {
                throw new DeploymentUnitProcessingException("Failed to parse 'standardjbosscmp-jdbc.xml'", (Throwable)e);
            }
            catch (Throwable throwable) {
                VFSUtils.safeClose(inputStream);
                throw throwable;
            }
        }
        VFSUtils.safeClose((Closeable)inputStream);
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT)).getRoot();
        VirtualFile descriptor = deploymentRoot.getChild("META-INF/jbosscmp-jdbc.xml");
        Object deploymentJdbcApplicationMetaData = null;
        if (descriptor != null && descriptor.exists()) {
            try {
                inputStream = descriptor.openStream();
                xmlReader = inputFactory.createXMLStreamReader(inputStream);
                jdbcMetaData = JDBCMetaDataParser.parse(xmlReader, jdbcMetaData);
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse jbosscmp-jdbc.xml: " + descriptor.getPathName(), (Throwable)e);
            }
            finally {
                VFSUtils.safeClose((Closeable)inputStream);
            }
        }
        deploymentUnit.putAttachment(Attachments.JDBC_APPLICATION_KEY, (Object)jdbcMetaData);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.JDBC_APPLICATION_KEY);
    }
}

