/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import javax.management.MBeanServer;
import org.jboss.as.jmx.MBeanRegistrationService;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.service.CreateDestroyService;
import org.jboss.as.service.ServiceNameFactory;
import org.jboss.as.service.StartStopService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;

final class MBeanServices {
    private final String mBeanName;
    private final ServiceName createDestroyServiceName;
    private final ServiceName startStopServiceName;
    private final Service<Object> createDestroyService;
    private final Service<Object> startStopService;
    private final ServiceBuilder<?> createDestroyServiceBuilder;
    private final ServiceBuilder<?> startStopServiceBuilder;
    private final ServiceTarget target;
    private boolean installed;

    MBeanServices(String mBeanName, Object mBeanInstance, ClassReflectionIndex<?> mBeanClassIndex, ServiceTarget target) {
        if (mBeanName == null || mBeanInstance == null || target == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        this.createDestroyService = new CreateDestroyService(mBeanInstance, mBeanClassIndex);
        this.createDestroyServiceName = ServiceNameFactory.newCreateDestroy(mBeanName);
        this.createDestroyServiceBuilder = target.addService(this.createDestroyServiceName, this.createDestroyService);
        this.startStopService = new StartStopService(mBeanInstance, mBeanClassIndex);
        this.startStopServiceName = ServiceNameFactory.newStartStop(mBeanName);
        this.startStopServiceBuilder = target.addService(this.startStopServiceName, this.startStopService);
        this.startStopServiceBuilder.addDependency(this.createDestroyServiceName);
        this.mBeanName = mBeanName;
        this.target = target;
    }

    Service<Object> getCreateDestroyService() {
        this.assertState();
        return this.createDestroyService;
    }

    Service<Object> getStartStopService() {
        this.assertState();
        return this.startStopService;
    }

    void addDependency(String dependencyMBeanName, Injector<Object> injector) {
        this.assertState();
        ServiceName injectedMBeanCreateDestroyServiceName = ServiceNameFactory.newCreateDestroy(dependencyMBeanName);
        this.createDestroyServiceBuilder.addDependency(injectedMBeanCreateDestroyServiceName, injector);
        ServiceName injectedMBeanStartStopServiceName = ServiceNameFactory.newStartStop(dependencyMBeanName);
        this.startStopServiceBuilder.addDependency(injectedMBeanStartStopServiceName);
    }

    void addInjectionValue(Injector<Object> injector, Value<?> value) {
        this.assertState();
        this.createDestroyServiceBuilder.addInjectionValue(injector, value);
    }

    void install() {
        this.assertState();
        this.createDestroyServiceBuilder.install();
        this.startStopServiceBuilder.install();
        MBeanRegistrationService mbeanRegistrationService = new MBeanRegistrationService(this.mBeanName);
        this.target.addService(MBeanRegistrationService.SERVICE_NAME.append(new String[]{this.mBeanName}), (Service)mbeanRegistrationService).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, mbeanRegistrationService.getMBeanServerInjector()).addDependency(this.startStopServiceName, Object.class, mbeanRegistrationService.getValueInjector()).install();
        this.installed = true;
    }

    private void assertState() {
        if (this.installed) {
            throw new IllegalStateException();
        }
    }
}

