/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.protocol.ProtocolChannel;
import org.jboss.as.protocol.ProtocolChannelFactory;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

public class ProtocolChannelClient<T extends ProtocolChannel>
implements Closeable {
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private final boolean startedEndpoint;
    private final Endpoint endpoint;
    private final Registration providerRegistration;
    private final URI uri;
    private final ProtocolChannelFactory<T> channelFactory;
    private volatile Connection connection;
    private final Set<T> channels = new HashSet<T>();

    private ProtocolChannelClient(boolean startedEndpoint, Endpoint endpoint, Registration providerRegistration, URI uri, ProtocolChannelFactory<T> channelFactory) {
        this.startedEndpoint = startedEndpoint;
        this.endpoint = endpoint;
        this.providerRegistration = providerRegistration;
        this.uri = uri;
        this.channelFactory = channelFactory;
    }

    public static <T extends ProtocolChannel> ProtocolChannelClient<T> create(Configuration<T> configuration) throws IOException, URISyntaxException {
        if (configuration == null) {
            throw ProtocolMessages.MESSAGES.nullVar("configuration");
        }
        configuration.validate();
        if (configuration.getEndpoint() != null) {
            Endpoint endpoint = configuration.getEndpoint();
            return new ProtocolChannelClient<T>(false, endpoint, null, configuration.getUri(), configuration.getChannelFactory());
        }
        Endpoint endpoint = Remoting.createEndpoint((String)configuration.getEndpointName(), (OptionMap)configuration.getOptionMap());
        Registration providerRegistration = endpoint.addConnectionProvider(configuration.getUri().getScheme(), (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE));
        return new ProtocolChannelClient<T>(true, endpoint, providerRegistration, configuration.getUri(), configuration.getChannelFactory());
    }

    public Connection connect(CallbackHandler handler) throws IOException {
        return this.connect(handler, null);
    }

    public Connection connect(CallbackHandler handler, Map<String, String> saslOptions) throws IOException {
        if (this.connection != null) {
            throw ProtocolMessages.MESSAGES.alreadyConnected();
        }
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE);
        if (!this.isLocal()) {
            builder.set(Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of((Object[])new String[]{JBOSS_LOCAL_USER}));
        }
        ArrayList<Property> tempProperties = new ArrayList<Property>(saslOptions != null ? saslOptions.size() : 1);
        tempProperties.add(Property.of((String)"jboss.sasl.local-user.quiet-auth", (String)"true"));
        if (saslOptions != null) {
            for (String currentKey : saslOptions.keySet()) {
                tempProperties.add(Property.of((String)currentKey, (String)saslOptions.get(currentKey)));
            }
        }
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(tempProperties));
        CallbackHandler actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        WrapperCallbackHandler wrapperHandler = new WrapperCallbackHandler(actualHandler);
        IoFuture future = this.endpoint.connect(this.uri, builder.getMap(), (CallbackHandler)wrapperHandler);
        try {
            this.connection = (Connection)future.get();
        }
        catch (CancellationException e) {
            throw ProtocolMessages.MESSAGES.connectWasCancelled();
        }
        catch (IOException e) {
            throw ProtocolMessages.MESSAGES.couldNotConnect(this.uri, e);
        }
        return this.connection;
    }

    private boolean isLocal() {
        try {
            String hostName = this.uri.getHost();
            InetAddress address = InetAddress.getByName(hostName);
            NetworkInterface nic = NetworkInterface.getByInetAddress(address);
            return address.isLoopbackAddress() || nic != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public T openChannel(String channelName) throws IOException {
        if (this.connection == null) {
            throw ProtocolMessages.MESSAGES.notConnected();
        }
        Channel channel = (Channel)this.connection.openChannel(channelName, OptionMap.EMPTY).get();
        T wrapped = this.channelFactory.create(channelName, channel);
        this.channels.add(wrapped);
        return wrapped;
    }

    @Override
    public void close() {
        for (ProtocolChannel channel : this.channels) {
            try {
                channel.writeShutdown();
            }
            catch (IOException iOException) {}
        }
        this.channels.clear();
        IoUtils.safeClose((Closeable)this.connection);
        if (this.startedEndpoint) {
            IoUtils.safeClose((Closeable)this.providerRegistration);
            IoUtils.safeClose((Closeable)this.endpoint);
        }
    }

    private static final class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }

    private static final class WrapperCallbackHandler
    implements CallbackHandler {
        private volatile boolean inCall = false;
        private volatile long callFinished = -1L;
        private final CallbackHandler wrapped;

        WrapperCallbackHandler(CallbackHandler toWrap) {
            this.wrapped = toWrap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            this.inCall = true;
            try {
                this.wrapped.handle(callbacks);
            }
            finally {
                this.callFinished = System.currentTimeMillis();
                this.inCall = false;
            }
        }

        boolean isInCall() {
            return this.inCall;
        }

        long getCallFinished() {
            return this.callFinished;
        }
    }

    public static final class Configuration<T extends ProtocolChannel> {
        private static final long DEFAULT_CONNECT_TIMEOUT = 5000L;
        private static final AtomicInteger COUNTER = new AtomicInteger();
        private Endpoint endpoint;
        private String endpointName;
        private OptionMap optionMap = OptionMap.EMPTY;
        private ThreadGroup group;
        private String uriScheme;
        private URI uri;
        private ProtocolChannelFactory<T> channelFactory;
        private static volatile boolean warnedExecutor;
        private static volatile boolean warnedConnectTimeout;
        private static volatile boolean warnedConnectTimeoutProperty;

        void validate() {
            if (this.endpointName == null && this.endpoint == null) {
                throw ProtocolMessages.MESSAGES.nullParameters("endpointName", "endpoint");
            }
            if (this.optionMap == null) {
                throw ProtocolMessages.MESSAGES.nullVar("optionMap");
            }
            if (this.uriScheme == null && this.endpoint == null) {
                throw ProtocolMessages.MESSAGES.nullVar("uriScheme");
            }
            if (this.uriScheme != null && this.endpoint != null) {
                throw ProtocolMessages.MESSAGES.cannotSetUriScheme();
            }
            if (this.uri == null) {
                throw ProtocolMessages.MESSAGES.nullVar("uri");
            }
            if (this.endpoint != null) {
                if (!this.uri.getScheme().equals("remote")) {
                    throw ProtocolMessages.MESSAGES.invalidUrl("remote");
                }
            } else if (!this.uriScheme.equals(this.uri.getScheme())) {
                throw ProtocolMessages.MESSAGES.unmatchedScheme(this.uriScheme, this.uri);
            }
            if (this.channelFactory == null) {
                throw ProtocolMessages.MESSAGES.nullVar("channelFactory");
            }
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public void setGroup(ThreadGroup group) {
            this.group = group;
        }

        public void setConnectTimeoutProperty(String connectTimeoutProperty) {
            boolean warned = warnedConnectTimeoutProperty;
            if (!warned) {
                warnedConnectTimeoutProperty = true;
                ProtocolLogger.CLIENT_LOGGER.connectTimeoutPropertyNotNeeded();
            }
        }

        public void setConnectTimeout(long connectTimeout) {
            boolean warned = warnedConnectTimeout;
            if (!warned) {
                warnedConnectTimeout = true;
                ProtocolLogger.CLIENT_LOGGER.connectTimeoutNotNeeded();
            }
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public ThreadGroup getGroup() {
            if (this.group == null) {
                this.group = new ThreadGroup("Remoting client threads " + COUNTER.incrementAndGet());
            }
            return this.group;
        }

        public String getUriScheme() {
            return this.uriScheme;
        }

        public void setUriScheme(String uriScheme) {
            this.uriScheme = uriScheme;
        }

        public OptionMap getOptionMap() {
            return this.optionMap;
        }

        public void setOptionMap(OptionMap optionMap) {
            this.optionMap = optionMap;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        @Deprecated
        public void setExecutor(Executor readExecutor) {
            boolean warned = warnedExecutor;
            if (!warned) {
                warnedExecutor = true;
                ProtocolLogger.CLIENT_LOGGER.executorNotNeeded();
            }
        }

        public ProtocolChannelFactory<T> getChannelFactory() {
            return this.channelFactory;
        }

        public void setChannelFactory(ProtocolChannelFactory<T> channelFactory) {
            this.channelFactory = channelFactory;
        }
    }
}

