/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

class ServerConfig {
    static int clockTick;
    static final int DEFAULT_CLOCK_TICK = 10000;
    static final long DEFAULT_IDLE_INTERVAL = 30L;
    static final int DEFAULT_MAX_IDLE_CONNECTIONS = 200;
    static final long DEFAULT_MAX_REQ_TIME = -1L;
    static final long DEFAULT_MAX_RSP_TIME = -1L;
    static final long DEFAULT_TIMER_MILLIS = 1000L;
    static final long DEFAULT_DRAIN_AMOUNT = 65536L;
    static long idleInterval;
    static long drainAmount;
    static int maxIdleConnections;
    static long maxReqTime;
    static long maxRspTime;
    static long timerMillis;
    static boolean debug;

    ServerConfig() {
    }

    static void checkLegacyProperties(final Logger logger) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("sun.net.httpserver.readTimeout") != null) {
                    logger.warning("sun.net.httpserver.readTimeout property is no longer used. Use sun.net.httpserver.maxReqTime instead.");
                }
                if (System.getProperty("sun.net.httpserver.writeTimeout") != null) {
                    logger.warning("sun.net.httpserver.writeTimeout property is no longer used. Use sun.net.httpserver.maxRspTime instead.");
                }
                if (System.getProperty("sun.net.httpserver.selCacheTimeout") != null) {
                    logger.warning("sun.net.httpserver.selCacheTimeout property is no longer used.");
                }
                return null;
            }
        });
    }

    static boolean debugEnabled() {
        return debug;
    }

    static long getIdleInterval() {
        return idleInterval;
    }

    static int getClockTick() {
        return clockTick;
    }

    static int getMaxIdleConnections() {
        return maxIdleConnections;
    }

    static long getDrainAmount() {
        return drainAmount;
    }

    static long getMaxReqTime() {
        return maxReqTime;
    }

    static long getMaxRspTime() {
        return maxRspTime;
    }

    static long getTimerMillis() {
        return timerMillis;
    }

    static {
        debug = false;
        idleInterval = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.idleInterval", 30L)) * 1000L;
        clockTick = AccessController.doPrivileged(new GetIntegerAction("sun.net.httpserver.clockTick", 10000));
        maxIdleConnections = AccessController.doPrivileged(new GetIntegerAction("sun.net.httpserver.maxIdleConnections", 200));
        drainAmount = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.drainAmount", 65536L));
        maxReqTime = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.maxReqTime", -1L));
        maxRspTime = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.maxRspTime", -1L));
        timerMillis = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.timerMillis", 1000L));
        debug = AccessController.doPrivileged(new GetBooleanAction("sun.net.httpserver.debug"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetBooleanAction
    implements PrivilegedAction<Boolean> {
        private final String property;

        public GetBooleanAction(String property) {
            this.property = property;
        }

        @Override
        public Boolean run() {
            return Boolean.getBoolean(this.property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetIntegerAction
    implements PrivilegedAction<Integer> {
        private final String property;
        private final int defaultVal;

        public GetIntegerAction(String property, int defaultVal) {
            this.property = property;
            this.defaultVal = defaultVal;
        }

        @Override
        public Integer run() {
            return Integer.getInteger(this.property, this.defaultVal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetLongAction
    implements PrivilegedAction<Long> {
        private final String property;
        private final long defaultVal;

        public GetLongAction(String property, long defaultVal) {
            this.property = property;
            this.defaultVal = defaultVal;
        }

        @Override
        public Long run() {
            return Long.getLong(this.property, this.defaultVal);
        }
    }
}

