/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.ietf.jgss.Oid;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.sasPolicy.ATLASPolicy;
import org.jacorb.sasPolicy.ATLASPolicyValues;
import org.jacorb.sasPolicy.SASPolicy;
import org.jacorb.sasPolicy.SASPolicyValues;
import org.jacorb.security.sas.ISASContext;
import org.omg.ATLAS.ATLASLocator;
import org.omg.ATLAS.ATLASProfile;
import org.omg.ATLAS.ATLASProfileHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.slf4j.Logger;

public class SASComponentInterceptor
extends LocalObject
implements IORInterceptor {
    private final Configuration config;
    private final Logger logger;
    private final ORB orb;
    private Codec codec;
    private TaggedComponent taggedComponent;
    private final ISASContext sasContext;

    public SASComponentInterceptor(ORBInitInfo oRBInitInfo) {
        this.orb = ((ORBInitInfoImpl)oRBInitInfo).getORB();
        this.config = this.orb.getConfiguration();
        this.logger = this.config.getLogger("jacorb.SAS.IOR");
        try {
            Encoding encoding = new Encoding(0, 1, 0);
            CodecFactory codecFactory = (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
            this.codec = codecFactory.create_codec(encoding);
        }
        catch (Exception exception) {
            this.logger.error("Error initing SASComponentInterceptor: ", (Throwable)exception);
        }
        this.sasContext = this.newSasContext();
        if (this.sasContext == null && this.logger.isErrorEnabled()) {
            this.logger.error("Could not load SAS context class: " + this.config.getAttribute("jacorb.security.sas.contextClass", ""));
        }
    }

    private ISASContext newSasContext() {
        try {
            return (ISASContext)this.config.getAttributeAsObject("jacorb.security.sas.contextClass");
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }

    public String name() {
        return "SASComponentCreator";
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establish_components(IORInfo iORInfo) {
        IDLEntity iDLEntity;
        IDLEntity iDLEntity2;
        if (this.sasContext == null) {
            return;
        }
        SASPolicyValues sASPolicyValues = null;
        try {
            iDLEntity2 = (SASPolicy)((IORInfoImpl)iORInfo).get_effective_policy(102);
            if (iDLEntity2 != null) {
                sASPolicyValues = iDLEntity2.value();
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.logger.debug("No SAS Policy");
        }
        catch (Exception exception) {
            this.logger.warn("Error fetching SAS policy", (Throwable)exception);
        }
        if (sASPolicyValues == null) {
            return;
        }
        if (sASPolicyValues.targetRequires == 0 && sASPolicyValues.targetSupports == 0) {
            return;
        }
        iDLEntity2 = null;
        try {
            iDLEntity = (ATLASPolicy)iORInfo.get_effective_policy(103);
            if (iDLEntity != null) {
                iDLEntity2 = iDLEntity.value();
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.logger.debug("No ATLAS Policy");
        }
        catch (Exception exception) {
            this.logger.warn("Error fetching ATLAS policy", (Throwable)exception);
        }
        try {
            if (this.taggedComponent == null) {
                Object object;
                CompoundSecMech[] compoundSecMechArray;
                IDLEntity iDLEntity3;
                iDLEntity = new TaggedComponent(34, new byte[0]);
                byte[] byArray = this.sasContext.getClientPrincipal().getBytes();
                ServiceConfiguration[] serviceConfigurationArray = null;
                if (iDLEntity2 == null) {
                    serviceConfigurationArray = new ServiceConfiguration[]{};
                } else {
                    if (((ATLASPolicyValues)iDLEntity2).atlasCache == null) {
                        ((ATLASPolicyValues)iDLEntity2).atlasCache = "";
                    }
                    iDLEntity3 = new ATLASLocator();
                    iDLEntity3.the_url(((ATLASPolicyValues)iDLEntity2).atlasURL);
                    ATLASProfile aTLASProfile = new ATLASProfile();
                    aTLASProfile.the_cache_id = ((ATLASPolicyValues)iDLEntity2).atlasCache.getBytes();
                    aTLASProfile.the_locator = iDLEntity3;
                    compoundSecMechArray = (CompoundSecMech[])new byte[0];
                    object = this.orb.create_any();
                    ATLASProfileHelper.insert((Any)object, aTLASProfile);
                    compoundSecMechArray = (CompoundSecMech[])this.codec.encode((Any)object);
                    serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(3, (byte[])compoundSecMechArray)};
                }
                iDLEntity3 = new SAS_ContextSec(0, 0, serviceConfigurationArray, new byte[0][0], 0);
                boolean bl = this.config.getAttributeAsBoolean("jacorb.security.sas.stateful", true);
                compoundSecMechArray = new CompoundSecMech[1];
                object = new Oid(this.sasContext.getMechOID());
                byte[] byArray2 = ((Oid)object).getDER();
                AS_ContextSec aS_ContextSec = new AS_ContextSec(sASPolicyValues.targetSupports, sASPolicyValues.targetRequires, byArray2, byArray);
                compoundSecMechArray[0] = new CompoundSecMech(sASPolicyValues.targetRequires, (TaggedComponent)iDLEntity, aS_ContextSec, (SAS_ContextSec)iDLEntity3);
                CompoundSecMechList compoundSecMechList = new CompoundSecMechList(bl, compoundSecMechArray);
                CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
                try {
                    cDROutputStream.beginEncapsulatedArray();
                    CompoundSecMechListHelper.write(cDROutputStream, compoundSecMechList);
                    this.taggedComponent = new TaggedComponent(33, cDROutputStream.getBufferCopy());
                }
                finally {
                    cDROutputStream.close();
                }
            }
            iORInfo.add_ior_component_to_profile(this.taggedComponent, 0);
        }
        catch (Exception exception) {
            this.logger.error("establish_components error: ", (Throwable)exception);
        }
    }
}

