/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.internal.util.collections.IdentityMap;

class EventCache
implements Map {
    private Map entityToCopyMap = IdentityMap.instantiate(10);
    private Map entityToOperatedOnFlagMap = IdentityMap.instantiate(10);

    EventCache() {
    }

    @Override
    public void clear() {
        this.entityToCopyMap.clear();
        this.entityToOperatedOnFlagMap.clear();
    }

    @Override
    public boolean containsKey(Object entity) {
        if (entity == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.containsKey(entity);
    }

    @Override
    public boolean containsValue(Object copy) {
        if (copy == null) {
            throw new NullPointerException("null copies are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.containsValue(copy);
    }

    public Set entrySet() {
        return this.entityToCopyMap.entrySet();
    }

    public Object get(Object entity) {
        if (entity == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.get(entity);
    }

    @Override
    public boolean isEmpty() {
        return this.entityToCopyMap.isEmpty();
    }

    public Set keySet() {
        return this.entityToCopyMap.keySet();
    }

    public Object put(Object entity, Object copy) {
        if (entity == null || copy == null) {
            throw new NullPointerException("null entities and copies are not supported by " + this.getClass().getName());
        }
        this.entityToOperatedOnFlagMap.put(entity, Boolean.FALSE);
        return this.entityToCopyMap.put(entity, copy);
    }

    Object put(Object entity, Object copy, boolean isOperatedOn) {
        if (entity == null || copy == null) {
            throw new NullPointerException("null entities and copies are not supported by " + this.getClass().getName());
        }
        this.entityToOperatedOnFlagMap.put(entity, isOperatedOn);
        return this.entityToCopyMap.put(entity, copy);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException("null entities and copies are not supported by " + this.getClass().getName());
            }
            this.entityToCopyMap.put(entry.getKey(), entry.getValue());
            this.entityToOperatedOnFlagMap.put(entry.getKey(), Boolean.FALSE);
        }
    }

    public Object remove(Object entity) {
        if (entity == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        this.entityToOperatedOnFlagMap.remove(entity);
        return this.entityToCopyMap.remove(entity);
    }

    @Override
    public int size() {
        return this.entityToCopyMap.size();
    }

    public Collection values() {
        return this.entityToCopyMap.values();
    }

    public boolean isOperatedOn(Object entity) {
        if (entity == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return (Boolean)this.entityToOperatedOnFlagMap.get(entity);
    }

    void setOperatedOn(Object entity, boolean isOperatedOn) {
        if (entity == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        if (!this.entityToOperatedOnFlagMap.containsKey(entity) || !this.entityToCopyMap.containsKey(entity)) {
            throw new AssertionFailure("called EventCache.setOperatedOn() for entity not found in EventCache");
        }
        this.entityToOperatedOnFlagMap.put(entity, isOperatedOn);
    }

    public Map invertMap() {
        return IdentityMap.invert(this.entityToCopyMap);
    }
}

