/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.as.controller.ModelController;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.model.ModelControllerMBeanHelper;
import org.jboss.as.jmx.model.ObjectNameAddressUtil;
import org.jboss.as.jmx.model.SecurityActions;

public class ModelControllerMBeanServer
implements MBeanServer {
    private final MBeanServer delegate;
    private final ModelControllerMBeanHelper helper;

    public ModelControllerMBeanServer(MBeanServer delegate, ModelController controller) {
        this.delegate = delegate;
        this.helper = new ModelControllerMBeanHelper(controller);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        if (ObjectNameAddressUtil.isReservedDomain(name)) {
            throw new NotCompliantMBeanException(JmxMessages.MESSAGES.reservedMBeanDomain("jboss.model"));
        }
        return this.delegate.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (ObjectNameAddressUtil.isReservedDomain(name)) {
            throw new NotCompliantMBeanException(JmxMessages.MESSAGES.reservedMBeanDomain("jboss.model"));
        }
        return this.delegate.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (ObjectNameAddressUtil.isReservedDomain(name)) {
            throw new NotCompliantMBeanException(JmxMessages.MESSAGES.reservedMBeanDomain("jboss.model"));
        }
        return this.delegate.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        if (ObjectNameAddressUtil.isReservedDomain(name)) {
            throw new NotCompliantMBeanException(JmxMessages.MESSAGES.reservedMBeanDomain("jboss.model"));
        }
        return this.delegate.createMBean(className, name);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        return this.delegate.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.delegate.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        return this.delegate.deserialize(className, loaderName, data);
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.getAttribute(name, attribute);
        }
        return this.helper.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.getAttributes(name, attributes);
        }
        return this.helper.getAttributes(name, attributes);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        if (this.delegate.isRegistered(loaderName)) {
            return this.delegate.getClassLoader(loaderName);
        }
        if (this.helper.resolvePathAddress(loaderName) != null) {
            return SecurityActions.getClassLoader(this.getClass());
        }
        throw ModelControllerMBeanHelper.createInstanceNotFoundException(loaderName);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        if (this.delegate.isRegistered(mbeanName)) {
            return this.delegate.getClassLoaderFor(mbeanName);
        }
        if (this.helper.resolvePathAddress(mbeanName) != null) {
            return SecurityActions.getClassLoader(this.getClass());
        }
        throw ModelControllerMBeanHelper.createInstanceNotFoundException(mbeanName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.delegate.getClassLoaderRepository();
    }

    @Override
    public String getDefaultDomain() {
        return this.delegate.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.delegate.getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        return this.delegate.getMBeanCount() + this.helper.getMBeanCount();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.getMBeanInfo(name);
        }
        return this.helper.getMBeanInfo(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.getObjectInstance(name);
        }
        return this.helper.getObjectInstance(name);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.delegate.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.delegate.instantiate(className, loaderName, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.delegate.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.delegate.instantiate(className);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.invoke(name, operationName, params, signature);
        }
        return this.helper.invoke(name, operationName, params, signature);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.isInstanceOf(name, className);
        }
        return false;
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        if (this.delegate.isRegistered(name)) {
            return true;
        }
        return this.helper.resolvePathAddress(name) != null;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        HashSet<ObjectInstance> mbeans = new HashSet<ObjectInstance>();
        mbeans.addAll(this.delegate.queryMBeans(name, query));
        mbeans.addAll(this.helper.queryMBeans(name, query));
        return mbeans;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        HashSet<ObjectName> mbeans = new HashSet<ObjectName>();
        mbeans.addAll(this.delegate.queryNames(name, query));
        mbeans.addAll(this.helper.queryNames(name, query));
        return mbeans;
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (ObjectNameAddressUtil.isReservedDomain(name)) {
            throw new MBeanRegistrationException(new RuntimeException(JmxMessages.MESSAGES.reservedMBeanDomain("jboss.model")));
        }
        return this.delegate.registerMBean(object, name);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.delegate.isRegistered(name)) {
            this.delegate.setAttribute(name, attribute);
            return;
        }
        this.helper.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (this.delegate.isRegistered(name)) {
            return this.delegate.setAttributes(name, attributes);
        }
        return this.helper.setAttributes(name, attributes);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (ObjectNameAddressUtil.isReservedDomain(name)) {
            throw new MBeanRegistrationException(new RuntimeException(JmxMessages.MESSAGES.reservedMBeanDomain("jboss.model")));
        }
        this.delegate.unregisterMBean(name);
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.delegate.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.delegate.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.delegate.removeNotificationListener(name, listener);
    }
}

