/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.modcluster.Connector;

public class CatalinaConnector
implements Connector {
    private final org.apache.catalina.connector.Connector connector;

    public CatalinaConnector(org.apache.catalina.connector.Connector connector) {
        this.connector = connector;
    }

    public InetAddress getAddress() {
        Object value = IntrospectionUtils.getProperty((Object)this.connector.getProtocolHandler(), (String)"address");
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        if (value instanceof String) {
            try {
                return InetAddress.getByName((String)value);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setAddress(InetAddress address) {
        IntrospectionUtils.setProperty((Object)this.connector.getProtocolHandler(), (String)"address", (String)address.getHostAddress());
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public Connector.Type getType() {
        if (CatalinaConnector.isAJP(this.connector)) {
            return Connector.Type.AJP;
        }
        ProtocolHandler handler = this.connector.getProtocolHandler();
        return Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)handler, (String)"SSLEnabled")) ? Connector.Type.HTTPS : Connector.Type.HTTP;
    }

    public boolean isReverse() {
        return Boolean.TRUE.equals(IntrospectionUtils.getProperty((Object)this.connector.getProtocolHandler(), (String)"reverseConnection"));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CatalinaConnector)) {
            return false;
        }
        CatalinaConnector connector = (CatalinaConnector)object;
        return this.connector == connector.connector;
    }

    public int hashCode() {
        return this.connector.hashCode();
    }

    public String toString() {
        InetAddress address = this.getAddress();
        return (Object)((Object)this.getType()) + "://" + (address != null ? address.getHostAddress() : "<undefined>") + ":" + this.connector.getPort();
    }

    public static boolean isAJP(org.apache.catalina.connector.Connector connector) {
        String protocol = connector.getProtocol();
        return protocol.startsWith("AJP") || protocol.startsWith("org.apache.coyote.ajp");
    }

    public boolean isAvailable() {
        try {
            return this.connector.isAvailable();
        }
        catch (NoSuchMethodError e) {
            try {
                String methodName = "getState";
                Class<?> clazz = this.connector.getClass();
                Method method = clazz.getMethod("getState", null);
                Object obj = method.invoke((Object)this.connector, (Object[])null);
                clazz = Class.forName("org.apache.catalina.LifecycleState");
                method = clazz.getMethod("isAvailable", null);
                boolean ret = (Boolean)method.invoke(obj, (Object[])null);
                return ret;
            }
            catch (Exception ex) {
                return true;
            }
        }
    }
}

