/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class LocalFileRepository
implements FileRepository,
Service<FileRepository> {
    private final File repositoryRoot;
    private final File deploymentRoot;
    private final File configurationRoot;

    public LocalFileRepository(HostControllerEnvironment environment) {
        this.repositoryRoot = environment.getDomainBaseDir();
        this.deploymentRoot = environment.getDomainDeploymentDir();
        this.configurationRoot = environment.getDomainConfigurationDir();
    }

    public File getFile(String relativePath) {
        return new File(this.repositoryRoot, relativePath);
    }

    public File getConfigurationFile(String relativePath) {
        return new File(this.configurationRoot, relativePath);
    }

    public File[] getDeploymentFiles(byte[] hash) {
        return this.getDeploymentRoot(hash).listFiles();
    }

    public File getDeploymentRoot(byte[] hash) {
        if (hash == null || hash.length == 0) {
            return this.deploymentRoot;
        }
        String hex = HashUtil.bytesToHexString((byte[])hash);
        File first = new File(this.deploymentRoot, hex.substring(0, 2));
        return new File(first, hex.substring(2));
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public FileRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

