/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostRootDescription {
    private static final String RESOURCE_NAME = HostRootDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, HostRootDescription.class.getClassLoader(), true, true);
    }

    public static ModelNode getDescription(Locale locale) {
        ResourceBundle bundle2 = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("host"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "namespaces"}).set(CommonDescriptions.getNamespacePrefixAttribute((Locale)locale));
        root.get(new String[]{"attributes", "schema-locations"}).set(CommonDescriptions.getSchemaLocationAttribute((Locale)locale));
        root.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("host.name"));
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "required"}).set(false);
        root.get(new String[]{"attributes", "name", "nillable"}).set(true);
        root.get(new String[]{"attributes", "name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "release-version", "description"}).set(bundle2.getString("host.release-version"));
        root.get(new String[]{"attributes", "release-version", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "release-version", "required"}).set(true);
        root.get(new String[]{"attributes", "release-version", "nillable"}).set(false);
        root.get(new String[]{"attributes", "release-version", "min-length"}).set(1);
        root.get(new String[]{"attributes", "release-codename", "description"}).set(bundle2.getString("host.release-codename"));
        root.get(new String[]{"attributes", "release-codename", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "release-codename", "required"}).set(true);
        root.get(new String[]{"attributes", "release-codename", "nillable"}).set(false);
        root.get(new String[]{"attributes", "release-codename", "min-length"}).set(1);
        root.get(new String[]{"attributes", "domain-controller", "description"}).set(bundle2.getString("host.domain-controller"));
        root.get(new String[]{"attributes", "domain-controller", "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"attributes", "domain-controller", "required"}).set(true);
        root.get(new String[]{"attributes", "domain-controller", "head-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "domain-controller", "tail-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "local", "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "local", "description"}).set(bundle2.getString("host.domain-controller.local"));
        root.get(new String[]{"attributes", "domain-controller", "value-type", "local", "required"}).set(false);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "description"}).set(bundle2.getString("host.domain-controller.remote"));
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "host", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "host", "description"}).set(bundle2.getString("host.domain-controller.remote.host"));
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "host", "required"}).set(true);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "host", "expressions-allowed"}).set(true);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "port", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "port", "description"}).set(bundle2.getString("host.domain-controller.remote.port"));
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "port", "required"}).set(true);
        root.get(new String[]{"attributes", "domain-controller", "value-type", "remote", "value-type", "port", "expressions-allowed"}).set(true);
        root.get(new String[]{"attributes", "master", "description"}).set(bundle2.getString("host.master"));
        root.get(new String[]{"attributes", "master", "type"}).set(ModelType.BOOLEAN);
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "extension", "description"}).set(bundle2.getString("host.extension"));
        root.get(new String[]{"children", "extension", "min-occurs"}).set(0);
        root.get(new String[]{"children", "extension", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "extension", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "path", "description"}).set(bundle2.getString("host.path"));
        root.get(new String[]{"children", "path", "min-occurs"}).set(0);
        root.get(new String[]{"children", "path", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "path", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "system-property", "description"}).set(bundle2.getString("host.system-properties"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "system-property", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "core-service", "description"}).set(bundle2.getString("host.core-services"));
        root.get(new String[]{"children", "core-service", "min-occurs"}).set(0);
        root.get(new String[]{"children", "core-service", "model-description"});
        root.get(new String[]{"children", "interface", "description"}).set(bundle2.getString("host.interface"));
        root.get(new String[]{"children", "interface", "min-occurs"}).set(0);
        root.get(new String[]{"children", "interface", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "interface", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "jvm", "description"}).set(bundle2.getString("host.jvm"));
        root.get(new String[]{"children", "jvm", "min-occurs"}).set(0);
        root.get(new String[]{"children", "jvm", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "jvm", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "server-config", "description"}).set(bundle2.getString("host.server-config"));
        root.get(new String[]{"children", "server-config", "min-occurs"}).set(0);
        root.get(new String[]{"children", "server-config", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "server-config", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "server", "description"}).set(bundle2.getString("host.server"));
        root.get(new String[]{"children", "server", "min-occurs"}).set(0);
        root.get(new String[]{"children", "server", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "server", "model-description"}).setEmptyObject();
        return root;
    }

    public static ModelNode getStartServerOperation(Locale locale) {
        ResourceBundle bundle2 = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("start-server");
        root.get("description").set(bundle2.getString("host.start-server"));
        root.get(new String[]{"request-properties", "server", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "server", "description"}).set(bundle2.getString("host.start-server.server"));
        root.get(new String[]{"request-properties", "server", "required"}).set(true);
        root.get(new String[]{"request-properties", "server", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "server", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("host.start-server.reply"));
        return root;
    }

    public static ModelNode getRestartServerOperation(Locale locale) {
        ResourceBundle bundle2 = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("restart-server");
        root.get("description").set(bundle2.getString("host.restart-server"));
        root.get(new String[]{"request-properties", "server", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "server", "description"}).set(bundle2.getString("host.restart-server.server"));
        root.get(new String[]{"request-properties", "server", "required"}).set(true);
        root.get(new String[]{"request-properties", "server", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "server", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("host.restart-server.reply"));
        return root;
    }

    public static ModelNode getStopServerOperation(Locale locale) {
        ResourceBundle bundle2 = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("stop-server");
        root.get("description").set(bundle2.getString("host.stop-server"));
        root.get(new String[]{"request-properties", "server", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "server", "description"}).set(bundle2.getString("host.stop-server.server"));
        root.get(new String[]{"request-properties", "server", "required"}).set(true);
        root.get(new String[]{"request-properties", "server", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "server", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("host.stop-server.reply"));
        return root;
    }

    public static ModelNode getSystemPropertiesDescription(Locale locale) {
        ResourceBundle bundle2 = HostRootDescription.getResourceBundle(locale);
        return CommonDescriptions.getSystemPropertyDescription((Locale)locale, (String)bundle2.getString("host.system-property"), (boolean)true);
    }

    public static ModelNode getLocalDomainControllerAdd(Locale locale) {
        ResourceBundle bundle2 = HostRootDescription.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("write-remote-domain-controller");
        result.get("description").set(bundle2.getString("host.domain-controller.local.add"));
        result.get("request-properties").setEmptyObject();
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    public static ModelNode getRemoteDomainControllerAdd(Locale locale) {
        ResourceBundle bundle2 = HostRootDescription.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("write-remote-domain-controller");
        result.get("description").set(bundle2.getString("host.domain-controller.remote.add"));
        result.get(new String[]{"request-properties", "host", "type"}).set(ModelType.STRING);
        result.get(new String[]{"request-properties", "host", "description"}).set(bundle2.getString("host.domain-controller.remote.host"));
        result.get(new String[]{"request-properties", "host", "required"}).set(true);
        result.get(new String[]{"request-properties", "host", "expressions-allowed"}).set(true);
        result.get(new String[]{"request-properties", "host", "min-length"}).set(1);
        result.get(new String[]{"request-properties", "port", "type"}).set(ModelType.STRING);
        result.get(new String[]{"request-properties", "port", "description"}).set(bundle2.getString("host.domain-controller.remote.port"));
        result.get(new String[]{"request-properties", "port", "required"}).set(true);
        result.get(new String[]{"request-properties", "port", "expressions-allowed"}).set(true);
        result.get(new String[]{"request-properties", "port", "min"}).set(1);
        result.get(new String[]{"request-properties", "port", "max"}).set(65535);
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

