/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainModelUtil;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RemoteDomainControllerAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-remote-domain-controller";
    public static final SimpleAttributeDefinition PORT = new SimpleAttributeDefinitionBuilder("port", ModelType.INT, false).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, 65535, false, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).build();
    public static final SimpleAttributeDefinition HOST = new SimpleAttributeDefinitionBuilder("host", ModelType.STRING, false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).build();
    private final ManagementResourceRegistration rootRegistration;
    private final HostControllerConfigurationPersister overallConfigPersister;
    private final FileRepository fileRepository;
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public static RemoteDomainControllerAddHandler getInstance(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, FileRepository fileRepository) {
        return new RemoteDomainControllerAddHandler(rootRegistration, hostControllerInfo, overallConfigPersister, fileRepository);
    }

    RemoteDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, FileRepository fileRepository) {
        this.rootRegistration = rootRegistration;
        this.overallConfigPersister = overallConfigPersister;
        this.fileRepository = fileRepository;
        this.hostControllerInfo = hostControllerInfo;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        ModelNode remoteDC = dc.get("remote");
        PORT.validateAndSet(operation, remoteDC);
        HOST.validateAndSet(operation, remoteDC);
        if (operation.has("security-realm")) {
            ModelNode securityRealm = operation.require("security-realm");
            dc.get(new String[]{"remote", "security-realm"}).set(securityRealm);
            this.hostControllerInfo.setRemoteDomainControllerSecurityRealm(securityRealm.resolve().asString());
        }
        if (dc.has("local")) {
            dc.remove("local");
        }
        this.hostControllerInfo.setMasterDomainController(false);
        this.hostControllerInfo.setRemoteDomainControllerHost(HOST.resolveModelAttribute(context, remoteDC).asString());
        this.hostControllerInfo.setRemoteDomainControllerPort(PORT.resolveModelAttribute(context, remoteDC).asInt());
        this.overallConfigPersister.initializeDomainConfigurationPersister(true);
        DomainModelUtil.initializeSlaveDomainRegistry((ManagementResourceRegistration)this.rootRegistration, (ExtensibleConfigurationPersister)this.overallConfigPersister.getDomainPersister(), (FileRepository)this.fileRepository, (LocalHostControllerInfo)this.hostControllerInfo);
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getRemoteDomainControllerAdd(locale);
    }
}

