/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.CommonXml;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DomainXml
extends CommonXml {
    public DomainXml(ModuleLoader loader, ExecutorService executorService) {
        super(loader, executorService);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        if (Element.forName((String)reader.getLocalName()) != Element.DOMAIN) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        Namespace readerNS = Namespace.forUri((String)reader.getNamespaceURI());
        switch (readerNS) {
            case DOMAIN_1_0: 
            case DOMAIN_1_1: {
                this.readDomainElement(reader, new ModelNode(), readerNS, nodes);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.DOMAIN.getLocalName());
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        if (modelNode.hasDefined("extension")) {
            this.writeExtensions(writer, modelNode.get("extension"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("system-property")) {
            this.writeProperties(writer, modelNode.get("system-property"), Element.SYSTEM_PROPERTIES, false);
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("profile")) {
            writer.writeStartElement(Element.PROFILES.getLocalName());
            for (Property profile : modelNode.get("profile").asPropertyList()) {
                this.writeProfile(writer, profile.getName(), profile.getValue(), context);
            }
            writer.writeEndElement();
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("socket-binding-group")) {
            writer.writeStartElement(Element.SOCKET_BINDING_GROUPS.getLocalName());
            for (Property property : modelNode.get("socket-binding-group").asPropertyList()) {
                this.writeSocketBindingGroup(writer, property.getValue(), false);
            }
            writer.writeEndElement();
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("deployment")) {
            this.writeDomainDeployments(writer, modelNode.get("deployment"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("server-group")) {
            writer.writeStartElement(Element.SERVER_GROUPS.getLocalName());
            for (Property property : modelNode.get("server-group").asPropertyList()) {
                this.writeServerGroup(writer, property.getName(), property.getValue());
            }
            writer.writeEndElement();
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        writer.writeEndElement();
        DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        writer.writeEndDocument();
    }

    void readDomainElement(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block7;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        if (element == Element.EXTENSIONS) {
            this.parseExtensions(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, expectedNs, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseDomainSocketBindingGroups(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, Set<String> interfaces) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING_GROUP: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: {
                            this.parseSocketBindingGroup_1_0(reader, interfaces, address, expectedNs, list);
                            continue block7;
                        }
                        case DOMAIN_1_1: {
                            this.parseSocketBindingGroup_1_1(reader, interfaces, address, expectedNs, list);
                            continue block7;
                        }
                    }
                    ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseSocketBindingGroup_1_0(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, Namespace expectedNs, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> includedGroups = new HashSet<String>();
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        String[] attrValues = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.DEFAULT_INTERFACE.getLocalName()});
        String socketBindingGroupName = attrValues[0];
        String defaultInterface = attrValues[1];
        ModelNode groupAddress = new ModelNode().set(address);
        groupAddress.add("socket-binding-group", socketBindingGroupName);
        ModelNode bindingGroupUpdate = new ModelNode();
        bindingGroupUpdate.get("address").set(groupAddress);
        bindingGroupUpdate.get("operation").set("add");
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(defaultInterface, bindingGroupUpdate, reader.getLocation());
        ModelNode includes = bindingGroupUpdate.get("includes");
        includes.setEmptyList();
        updates.add(bindingGroupUpdate);
        block4: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INCLUDE: {
                    String includedGroup = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SOCKET_BINDING_GROUP.getLocalName());
                    if (!includedGroups.add(includedGroup)) {
                        throw ControllerMessages.MESSAGES.alreadyDeclared(Attribute.SOCKET_BINDING_GROUP.getLocalName(), includedGroup, reader.getLocation());
                    }
                    SocketBindingGroupResourceDefinition.INCLUDES.parseAndAddParameterElement(includedGroup, bindingGroupUpdate, reader.getLocation());
                    continue block4;
                }
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block4;
                    throw ControllerMessages.MESSAGES.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseSocketBindingGroup_1_1(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, Namespace expectedNs, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> includedGroups = new HashSet<String>();
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        String[] attrValues = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.DEFAULT_INTERFACE.getLocalName()});
        String socketBindingGroupName = attrValues[0];
        String defaultInterface = attrValues[1];
        ModelNode groupAddress = new ModelNode().set(address);
        groupAddress.add("socket-binding-group", socketBindingGroupName);
        ModelNode bindingGroupUpdate = new ModelNode();
        bindingGroupUpdate.get("address").set(groupAddress);
        bindingGroupUpdate.get("operation").set("add");
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(defaultInterface, bindingGroupUpdate, reader.getLocation());
        ModelNode includes = bindingGroupUpdate.get("includes");
        includes.setEmptyList();
        updates.add(bindingGroupUpdate);
        block5: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INCLUDE: {
                    String includedGroup = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SOCKET_BINDING_GROUP.getLocalName());
                    if (!includedGroups.add(includedGroup)) {
                        throw ControllerMessages.MESSAGES.alreadyDeclared(Attribute.SOCKET_BINDING_GROUP.getLocalName(), includedGroup, reader.getLocation());
                    }
                    SocketBindingGroupResourceDefinition.INCLUDES.parseAndAddParameterElement(includedGroup, bindingGroupUpdate, reader.getLocation());
                    continue block5;
                }
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block5;
                    throw ControllerMessages.MESSAGES.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, socketBindingGroupName, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block5;
                    throw ControllerMessages.MESSAGES.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseServerGroups(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element serverGroup = Element.forName((String)reader.getLocalName());
            if (Element.SERVER_GROUP != serverGroup) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String name = null;
            String profile = null;
            Boolean managementSubsystemEndpoint = null;
            int count = reader.getAttributeCount();
            block12: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (name != null) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                        }
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                        }
                        name = value;
                        continue block12;
                    }
                    case PROFILE: {
                        if (profile != null) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                        }
                        profile = value;
                        continue block12;
                    }
                    case MANAGEMENT_SUBSYSTEM_ENDPOINT: {
                        if (managementSubsystemEndpoint != null) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                        }
                        managementSubsystemEndpoint = Boolean.valueOf(value);
                        continue block12;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            if (profile == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PROFILE));
            }
            ModelNode groupAddress = new ModelNode().set(address);
            groupAddress.add("server-group", name);
            ModelNode group = new ModelNode();
            group.get("operation").set("add");
            group.get("address").set(groupAddress);
            group.get("profile").set(profile);
            if (managementSubsystemEndpoint != null) {
                group.get("management-subsystem-endpoint").set(managementSubsystemEndpoint.booleanValue());
            }
            list.add(group);
            boolean sawDeployments = false;
            block13: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case JVM: {
                        this.parseJvm(reader, groupAddress, expectedNs, list, new HashSet());
                        continue block13;
                    }
                    case SOCKET_BINDING_GROUP: {
                        this.parseSocketBindingGroupRef(reader, groupAddress, list);
                        continue block13;
                    }
                    case DEPLOYMENTS: {
                        if (sawDeployments) {
                            throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                        }
                        sawDeployments = true;
                        this.parseDeployments(reader, groupAddress, expectedNs, list, true);
                        continue block13;
                    }
                    case SYSTEM_PROPERTIES: {
                        this.parseSystemProperties(reader, groupAddress, expectedNs, list, false);
                        continue block13;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    void parseProfiles(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (Element.PROFILE != element) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw ControllerMessages.MESSAGES.duplicateDeclaration("profile", name, reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            HashSet<String> includes = new HashSet<String>();
            ModelNode profileIncludes = new ModelNode();
            HashSet<String> configuredSubsystemTypes = new HashSet<String>();
            block5: while (reader.nextTag() != 2) {
                switch (Namespace.forUri((String)reader.getNamespaceURI())) {
                    case UNKNOWN: {
                        if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        if (!configuredSubsystemTypes.add(reader.getNamespaceURI())) {
                            throw ControllerMessages.MESSAGES.duplicateDeclaration("subsystem", name, reader.getLocation());
                        }
                        reader.handleAny(subsystems);
                        continue block5;
                    }
                    case DOMAIN_1_0: 
                    case DOMAIN_1_1: {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                        if (configuredSubsystemTypes.size() > 0) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        if (Element.forName((String)reader.getLocalName()) != Element.INCLUDE) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String includedName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.PROFILE.getLocalName());
                        if (!names.contains(includedName)) {
                            throw ControllerMessages.MESSAGES.profileNotFound(reader.getLocation());
                        }
                        if (!includes.add(includedName)) {
                            throw ControllerMessages.MESSAGES.duplicateProfile(reader.getLocation());
                        }
                        profileIncludes.add(includedName);
                        continue block5;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ModelNode profile = new ModelNode();
            profile.get("operation").set("add");
            profile.get("address").set(address).add("profile", name);
            profile.get("includes").set(profileIncludes);
            list.add(profile);
            for (ModelNode update : subsystems) {
                ModelNode subsystemAddress = address.clone().set(address).add("profile", name);
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
            if (configuredSubsystemTypes.size() != 0) continue;
            throw ControllerMessages.MESSAGES.profileHasNoSubsystems(reader.getLocation());
        }
    }

    void parseSubsystemManagementEndpoint(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProfile(XMLExtendedStreamWriter writer, String profileName, ModelNode profileNode, ModelMarshallingContext context) throws XMLStreamException {
        Set subsystemNames;
        writer.writeStartElement(Element.PROFILE.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), profileName);
        if (profileNode.hasDefined("includes")) {
            for (ModelNode include : profileNode.get("includes").asList()) {
                writer.writeEmptyElement("include");
                writer.writeAttribute("profile", include.asString());
            }
        }
        if (profileNode.hasDefined("subsystem") && (subsystemNames = profileNode.get("subsystem").keys()).size() > 0) {
            String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
            for (String subsystemName : subsystemNames) {
                try {
                    ModelNode subsystem = profileNode.get(new String[]{"subsystem", subsystemName});
                    XMLElementWriter subsystemWriter = context.getSubsystemWriter(subsystemName);
                    if (subsystemWriter == null) continue;
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
                finally {
                    writer.setDefaultNamespace(defaultNamespace);
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeDomainDeployments(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set deploymentNames = modelNode.keys();
        if (deploymentNames.size() > 0) {
            writer.writeStartElement(Element.DEPLOYMENTS.getLocalName());
            for (String uniqueName : deploymentNames) {
                ModelNode deployment = modelNode.get(uniqueName);
                String runtimeName = deployment.get("runtime-name").asString();
                writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)uniqueName);
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.RUNTIME_NAME, (String)runtimeName);
                List contentItems = deployment.require("content").asList();
                for (ModelNode contentItem : contentItems) {
                    DomainXml.writeContentItem((XMLExtendedStreamWriter)writer, (ModelNode)contentItem);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeServerGroupDeployments(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set deploymentNames = modelNode.keys();
        if (deploymentNames.size() > 0) {
            writer.writeStartElement(Element.DEPLOYMENTS.getLocalName());
            for (String uniqueName : deploymentNames) {
                ModelNode deployment = modelNode.get(uniqueName);
                String runtimeName = deployment.get("runtime-name").asString();
                boolean enabled = !deployment.hasDefined("enabled") || deployment.get("enabled").asBoolean();
                writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)uniqueName);
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.RUNTIME_NAME, (String)runtimeName);
                if (!enabled) {
                    DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.ENABLED, (String)Boolean.FALSE.toString());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeServerGroup(XMLExtendedStreamWriter writer, String groupName, ModelNode group) throws XMLStreamException {
        Boolean managementSubsystemEndpoint;
        Iterator i$;
        writer.writeStartElement(Element.SERVER_GROUP.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), groupName);
        writer.writeAttribute(Attribute.PROFILE.getLocalName(), group.get("profile").asString());
        if (group.hasDefined("jvm") && (i$ = group.get("jvm").asPropertyList().iterator()).hasNext()) {
            Property jvm = (Property)i$.next();
            this.writeJVMElement(writer, jvm.getName(), jvm.getValue());
        }
        String bindingGroupRef = group.hasDefined("socket-binding-group") ? group.get("socket-binding-group").asString() : null;
        String portOffset = group.hasDefined("socket-binding-port-offset") ? group.get("socket-binding-port-offset").asString() : null;
        Boolean bl = managementSubsystemEndpoint = group.hasDefined("management-subsystem-endpoint") ? Boolean.valueOf(group.get("management-subsystem-endpoint").asBoolean()) : null;
        if (bindingGroupRef != null || portOffset != null) {
            writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
            if (bindingGroupRef != null) {
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.REF, (String)bindingGroupRef);
            }
            if (portOffset != null) {
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.PORT_OFFSET, (String)portOffset);
            }
            if (managementSubsystemEndpoint != null) {
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.MANAGEMENT_SUBSYSTEM_ENDPOINT, (String)managementSubsystemEndpoint.toString());
            }
            writer.writeEndElement();
        }
        if (group.hasDefined("deployment")) {
            this.writeServerGroupDeployments(writer, group.get("deployment"));
        }
        if (group.hasDefined("system-property")) {
            this.writeProperties(writer, group.get("system-property"), Element.SYSTEM_PROPERTIES, false);
        }
        writer.writeEndElement();
    }
}

