/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;

public class SimpleTable {
    private final Object[] header;
    private final int[] columnLengths;
    private final List<String[]> lines = new ArrayList<String[]>();

    public SimpleTable(String[] header) {
        if (header == null || header.length == 0) {
            throw new IllegalArgumentException("header can't be null or empty.");
        }
        this.header = new String[header.length];
        this.columnLengths = new int[header.length];
        for (int i = 0; i < header.length; ++i) {
            String name = header[i];
            if (name == null) {
                throw new IllegalArgumentException("One of the headers is null: " + Arrays.asList(header));
            }
            this.header[i] = name;
            this.columnLengths[i] = name.length() + 1;
        }
    }

    public void addLine(String[] line) {
        if (line == null) {
            throw new IllegalArgumentException("The line can't be null.");
        }
        if (line.length != this.header.length) {
            throw new IllegalArgumentException("Line length " + line.length + " doesn't match headers' length " + this.header.length);
        }
        String[] values = new String[line.length];
        for (int i = 0; i < line.length; ++i) {
            String value = line[i];
            if (value == null) {
                value = "null";
            }
            values[i] = value;
            if (this.columnLengths[i] >= value.length() + 1) continue;
            this.columnLengths[i] = value.length() + 1;
        }
        this.lines.add(values);
    }

    public int size() {
        return this.lines.size();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var6_8;
        StringBuilder buf = new StringBuilder();
        Formatter formatter = new Formatter(buf);
        StringBuilder formatBuf = new StringBuilder();
        int[] arr$ = this.columnLengths;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            int length = arr$[var6_8];
            formatBuf.append("%-").append(length).append('s');
            ++var6_8;
        }
        String format = formatBuf.toString();
        formatter.format(format, this.header);
        for (Object[] objectArray : this.lines) {
            buf.append('\n');
            formatter.format(format, objectArray);
        }
        return buf.toString();
    }
}

