/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.BufferAllocator;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;

public final class Buffers {
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    private Buffers() {
    }

    public static <T extends Buffer> T flip(T buffer) {
        buffer.flip();
        return buffer;
    }

    public static <T extends Buffer> T clear(T buffer) {
        buffer.clear();
        return buffer;
    }

    public static <T extends Buffer> T limit(T buffer, int limit) {
        buffer.limit(limit);
        return buffer;
    }

    public static <T extends Buffer> T mark(T buffer) {
        buffer.mark();
        return buffer;
    }

    public static <T extends Buffer> T position(T buffer, int position) {
        buffer.position(position);
        return buffer;
    }

    public static <T extends Buffer> T reset(T buffer) {
        buffer.reset();
        return buffer;
    }

    public static <T extends Buffer> T rewind(T buffer) {
        buffer.rewind();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer slice(ByteBuffer buffer, int sliceSize) {
        int oldRem = buffer.remaining();
        if (sliceSize > oldRem || sliceSize < -oldRem) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ByteBuffer byteBuffer = buffer.slice();
                return byteBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ByteBuffer byteBuffer = buffer.slice();
            return byteBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer copy(ByteBuffer buffer, int sliceSize, BufferAllocator<ByteBuffer> allocator) {
        int oldRem = buffer.remaining();
        if (sliceSize > oldRem || sliceSize < -oldRem) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            ByteBuffer target = allocator.allocate(-sliceSize);
            buffer.limit(oldLim + sliceSize);
            try {
                target.put(buffer);
                ByteBuffer byteBuffer = target;
                return byteBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        ByteBuffer target = allocator.allocate(sliceSize);
        buffer.limit(oldPos + sliceSize);
        try {
            target.put(buffer);
            ByteBuffer byteBuffer = target;
            return byteBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static int copy(ByteBuffer destination, ByteBuffer source) {
        int sr = source.remaining();
        int dr = destination.remaining();
        if (dr >= sr) {
            destination.put(source);
            return sr;
        }
        destination.put(Buffers.slice(source, dr));
        return dr;
    }

    public static int copy(ByteBuffer[] destinations, int offset, int length, ByteBuffer source) {
        int t = 0;
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = destinations[i + offset];
            int rem = buffer.remaining();
            if (rem == 0) continue;
            if (rem < source.remaining()) {
                buffer.put(Buffers.slice(source, rem));
                t += rem;
                continue;
            }
            buffer.put(source);
            return t += source.remaining();
        }
        return t;
    }

    public static int copy(ByteBuffer destination, ByteBuffer[] sources, int offset, int length) {
        int t = 0;
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = sources[i + offset];
            int rem = buffer.remaining();
            if (rem == 0) continue;
            if (rem > destination.remaining()) {
                destination.put(Buffers.slice(buffer, rem));
                return t += rem;
            }
            destination.put(buffer);
            t += rem;
        }
        return t;
    }

    public static long copy(ByteBuffer[] destinations, int destOffset, int destLength, ByteBuffer[] sources, int srcOffset, int srcLength) {
        long t = 0L;
        int s = 0;
        int d = 0;
        if (destLength == 0 || srcLength == 0) {
            return 0L;
        }
        ByteBuffer source = sources[srcOffset];
        ByteBuffer dest = destinations[destOffset];
        while (s < srcLength && d < destLength) {
            int dr;
            int sr = source.remaining();
            if (sr < (dr = dest.remaining())) {
                dest.put(source);
                source = sources[srcOffset + ++s];
                t += (long)sr;
                continue;
            }
            if (sr > dr) {
                dest.put(Buffers.slice(source, dr));
                dest = destinations[destOffset + ++d];
                t += (long)dr;
                continue;
            }
            dest.put(source);
            source = sources[srcOffset + ++s];
            dest = destinations[destOffset + ++d];
            t += (long)sr;
        }
        return t;
    }

    public static int copy(int count, ByteBuffer destination, ByteBuffer source) {
        int cnt = Math.min(Math.min(count, source.remaining()), destination.remaining());
        destination.put(Buffers.slice(source, cnt));
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(int count, ByteBuffer[] destinations, int offset, int length, ByteBuffer source) {
        if (source.remaining() > count) {
            int oldLimit = source.limit();
            try {
                source.limit(source.position() + count);
                int n = Buffers.copy(destinations, offset, length, source);
                return n;
            }
            finally {
                source.limit(oldLimit);
            }
        }
        return Buffers.copy(destinations, offset, length, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(int count, ByteBuffer destination, ByteBuffer[] sources, int offset, int length) {
        if (destination.remaining() > count) {
            int oldLimit = destination.limit();
            try {
                destination.limit(destination.position() + count);
                int n = Buffers.copy(sources, offset, length, destination);
                return n;
            }
            finally {
                destination.limit(oldLimit);
            }
        }
        return Buffers.copy(sources, offset, length, destination);
    }

    public static long copy(long count, ByteBuffer[] destinations, int destOffset, int destLength, ByteBuffer[] sources, int srcOffset, int srcLength) {
        long t = 0L;
        int s = 0;
        int d = 0;
        if (destLength == 0 || srcLength == 0 || count <= 0L) {
            return 0L;
        }
        ByteBuffer source = sources[srcOffset];
        ByteBuffer dest = destinations[destOffset];
        while (s < srcLength && d < destLength) {
            int dr;
            int sr = source.remaining();
            if (sr < (dr = (int)Math.min(count, (long)dest.remaining()))) {
                dest.put(source);
                source = sources[srcOffset + ++s];
                t += (long)sr;
                count -= (long)sr;
                continue;
            }
            if (sr > dr) {
                dest.put(Buffers.slice(source, dr));
                dest = destinations[destOffset + ++d];
                t += (long)dr;
                count -= (long)dr;
                continue;
            }
            dest.put(source);
            source = sources[srcOffset + ++s];
            dest = destinations[destOffset + ++d];
            t += (long)sr;
            count -= (long)sr;
        }
        return t;
    }

    public static ByteBuffer fill(ByteBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (byte)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((byte)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBuffer slice(CharBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                CharBuffer charBuffer = buffer.slice();
                return charBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            CharBuffer charBuffer = buffer.slice();
            return charBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static CharBuffer fill(CharBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (char)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((char)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer slice(ShortBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ShortBuffer shortBuffer = buffer.slice();
                return shortBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ShortBuffer shortBuffer = buffer.slice();
            return shortBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static ShortBuffer fill(ShortBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (short)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((short)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntBuffer slice(IntBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                IntBuffer intBuffer = buffer.slice();
                return intBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            IntBuffer intBuffer = buffer.slice();
            return intBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static IntBuffer fill(IntBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put(value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongBuffer slice(LongBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                LongBuffer longBuffer = buffer.slice();
                return longBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            LongBuffer longBuffer = buffer.slice();
            return longBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static LongBuffer fill(LongBuffer buffer, long value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put(value);
            }
        }
        return buffer;
    }

    public static <T extends Buffer> T skip(T buffer, int cnt) throws BufferUnderflowException {
        if (cnt < 0) {
            throw new IllegalArgumentException();
        }
        if (cnt > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        buffer.position(buffer.position() + cnt);
        return buffer;
    }

    public static int trySkip(Buffer buffer, int cnt) {
        if (cnt < 0) {
            throw new IllegalArgumentException();
        }
        int rem = buffer.remaining();
        if (cnt > rem) {
            cnt = rem;
        }
        buffer.position(buffer.position() + cnt);
        return cnt;
    }

    public static long trySkip(Buffer[] buffers, int offs, int len, long cnt) {
        if (cnt < 0L) {
            throw new IllegalArgumentException();
        }
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (offs < 0 || offs > buffers.length || offs + len > buffers.length) {
            throw new IllegalArgumentException();
        }
        long c = 0L;
        for (int i = 0; i < len; ++i) {
            Buffer buffer = buffers[offs + i];
            int rem = buffer.remaining();
            if ((long)rem < cnt) {
                buffer.position(buffer.position() + rem);
                cnt -= (long)rem;
                c += (long)rem;
                continue;
            }
            buffer.position(buffer.position() + (int)cnt);
            return c - cnt;
        }
        return c;
    }

    public static <T extends Buffer> T unget(T buffer, int cnt) {
        if (cnt < 0) {
            throw new IllegalArgumentException();
        }
        if (cnt > buffer.position()) {
            throw new BufferUnderflowException();
        }
        buffer.position(buffer.position() - cnt);
        return buffer;
    }

    public static byte[] take(ByteBuffer buffer, int cnt) {
        byte[] bytes = new byte[cnt];
        buffer.get(bytes);
        return bytes;
    }

    public static char[] take(CharBuffer buffer, int cnt) {
        char[] chars = new char[cnt];
        buffer.get(chars);
        return chars;
    }

    public static short[] take(ShortBuffer buffer, int cnt) {
        short[] shorts = new short[cnt];
        buffer.get(shorts);
        return shorts;
    }

    public static int[] take(IntBuffer buffer, int cnt) {
        int[] ints = new int[cnt];
        buffer.get(ints);
        return ints;
    }

    public static long[] take(LongBuffer buffer, int cnt) {
        long[] longs = new long[cnt];
        buffer.get(longs);
        return longs;
    }

    public static byte[] take(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static char[] take(CharBuffer buffer) {
        char[] chars = new char[buffer.remaining()];
        buffer.get(chars);
        return chars;
    }

    public static short[] take(ShortBuffer buffer) {
        short[] shorts = new short[buffer.remaining()];
        buffer.get(shorts);
        return shorts;
    }

    public static int[] take(IntBuffer buffer) {
        int[] ints = new int[buffer.remaining()];
        buffer.get(ints);
        return ints;
    }

    public static long[] take(LongBuffer buffer) {
        long[] longs = new long[buffer.remaining()];
        buffer.get(longs);
        return longs;
    }

    public static Object createDumper(final ByteBuffer buffer, final int indent, final int columns) {
        return new Object(){

            public String toString() {
                StringBuilder b = new StringBuilder();
                try {
                    Buffers.dump(buffer, (Appendable)b, indent, columns);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return b.toString();
            }
        };
    }

    public static void dump(ByteBuffer buffer, Appendable dest, int indent, int columns) throws IOException {
        int pos = buffer.position();
        int remaining = buffer.remaining();
        int rowLength = 8 << columns - 1;
        int n = Math.max(Integer.toString(buffer.remaining(), 16).length(), 4);
        for (int idx = 0; idx < remaining; idx += rowLength) {
            for (int i = 0; i < indent; ++i) {
                dest.append(' ');
            }
            String s = Integer.toString(idx, 16);
            for (int i = n - s.length(); i > 0; --i) {
                dest.append('0');
            }
            dest.append(s);
            dest.append(" - ");
            Buffers.appendHexRow(buffer, dest, pos + idx, columns);
            Buffers.appendTextRow(buffer, dest, pos + idx, columns);
            dest.append('\n');
        }
    }

    private static void appendHexRow(ByteBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                if (pos >= limit) {
                    dest.append("  ");
                } else {
                    int v = buffer.get(pos++) & 0xFF;
                    String hexVal = Integer.toString(v, 16);
                    if (v < 16) {
                        dest.append('0');
                    }
                    dest.append(hexVal);
                }
                dest.append(' ');
            }
            dest.append(' ');
            dest.append(' ');
        }
    }

    private static void appendTextRow(ByteBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        dest.append('[');
        dest.append(' ');
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                char v;
                if (pos >= limit) {
                    dest.append(' ');
                    continue;
                }
                if (Character.isISOControl(v = (char)(buffer.get(pos++) & 0xFF))) {
                    dest.append('.');
                    continue;
                }
                dest.append(v);
            }
            dest.append(' ');
        }
        dest.append(']');
    }

    public static Object createDumper(final CharBuffer buffer, final int indent, final int columns) {
        return new Object(){

            public String toString() {
                StringBuilder b = new StringBuilder();
                try {
                    Buffers.dump(buffer, (Appendable)b, indent, columns);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return b.toString();
            }
        };
    }

    public static void dump(CharBuffer buffer, Appendable dest, int indent, int columns) throws IOException {
        int pos = buffer.position();
        int remaining = buffer.remaining();
        int rowLength = 8 << columns - 1;
        int n = Math.max(Integer.toString(buffer.remaining(), 16).length(), 4);
        for (int idx = 0; idx < remaining; idx += rowLength) {
            for (int i = 0; i < indent; ++i) {
                dest.append(' ');
            }
            String s = Integer.toString(idx, 16);
            for (int i = n - s.length(); i > 0; --i) {
                dest.append('0');
            }
            dest.append(s);
            dest.append(" - ");
            Buffers.appendHexRow(buffer, dest, pos + idx, columns);
            Buffers.appendTextRow(buffer, dest, pos + idx, columns);
            dest.append('\n');
        }
    }

    private static void appendHexRow(CharBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                if (pos >= limit) {
                    dest.append("  ");
                } else {
                    char v = buffer.get(pos++);
                    String hexVal = Integer.toString(v, 16);
                    dest.append("0000".substring(hexVal.length()));
                    dest.append(hexVal);
                }
                dest.append(' ');
            }
            dest.append(' ');
            dest.append(' ');
        }
    }

    private static void appendTextRow(CharBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        dest.append('[');
        dest.append(' ');
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                char v;
                if (pos >= limit) {
                    dest.append(' ');
                    continue;
                }
                if (Character.isISOControl(v = buffer.get(pos++)) || Character.isHighSurrogate(v) || Character.isLowSurrogate(v)) {
                    dest.append('.');
                    continue;
                }
                dest.append(v);
            }
            dest.append(' ');
        }
        dest.append(']');
    }

    public static boolean hasRemaining(Buffer[] buffers, int offs, int len) {
        for (int i = 0; i < len; ++i) {
            if (!buffers[i + offs].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRemaining(Buffer[] buffers) {
        return Buffers.hasRemaining(buffers, 0, buffers.length);
    }

    public static long remaining(Buffer[] buffers, int offs, int len) {
        long t = 0L;
        for (int i = 0; i < len; ++i) {
            t += (long)buffers[i + offs].remaining();
        }
        return t;
    }

    public static long remaining(Buffer[] buffers) {
        return Buffers.remaining(buffers, 0, buffers.length);
    }

    public static ByteBuffer putModifiedUtf8(ByteBuffer dest, String orig) throws BufferOverflowException {
        char[] chars;
        for (char c : chars = orig.toCharArray()) {
            if (c > '\u0000' && c <= '\u007f') {
                dest.put((byte)c);
                continue;
            }
            if (c <= '\u07ff') {
                dest.put((byte)(0xC0 | 0x1F & c >> 6));
                dest.put((byte)(0x80 | 0x3F & c));
                continue;
            }
            dest.put((byte)(0xE0 | 0xF & c >> 12));
            dest.put((byte)(0x80 | 0x3F & c >> 6));
            dest.put((byte)(0x80 | 0x3F & c));
        }
        return dest;
    }

    public static String getModifiedUtf8Z(ByteBuffer src) throws BufferUnderflowException {
        StringBuilder builder = new StringBuilder();
        int ch;
        while ((ch = Buffers.readUTFChar(src)) != -1) {
            builder.append((char)ch);
        }
        return builder.toString();
    }

    public static String getModifiedUtf8(ByteBuffer src) throws BufferUnderflowException {
        StringBuilder builder = new StringBuilder();
        while (src.hasRemaining()) {
            int ch = Buffers.readUTFChar(src);
            if (ch == -1) {
                builder.append('\u0000');
                continue;
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private static int readUTFChar(ByteBuffer src) throws BufferUnderflowException {
        int a = src.get() & 0xFF;
        if (a == 0) {
            return -1;
        }
        if (a < 128) {
            return (char)a;
        }
        if (a < 192) {
            return 63;
        }
        if (a < 224) {
            int b = src.get() & 0xFF;
            if ((b & 0xC0) != 128) {
                return 63;
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = src.get() & 0xFF;
            if ((b & 0xC0) != 128) {
                return 63;
            }
            int c = src.get() & 0xFF;
            if ((c & 0xC0) != 128) {
                return 63;
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        return 63;
    }

    public static boolean readAsciiZ(ByteBuffer src, StringBuilder builder) {
        return Buffers.readAsciiZ(src, builder, '?');
    }

    public static boolean readAsciiZ(ByteBuffer src, StringBuilder builder, char replacement) {
        while (src.hasRemaining()) {
            byte b = src.get();
            if (b == 0) {
                return true;
            }
            builder.append(b < 0 ? replacement : (char)b);
        }
        return false;
    }

    public static boolean readAsciiLine(ByteBuffer src, StringBuilder builder) {
        return Buffers.readAsciiLine(src, builder, '?', '\n');
    }

    public static boolean readAsciiLine(ByteBuffer src, StringBuilder builder, char replacement) {
        return Buffers.readAsciiLine(src, builder, replacement, '\n');
    }

    public static boolean readAsciiLine(ByteBuffer src, StringBuilder builder, char replacement, char delimiter) {
        byte b;
        do {
            if (!src.hasRemaining()) {
                return false;
            }
            b = src.get();
            builder.append(b < 0 ? replacement : (char)b);
        } while (b != delimiter);
        return true;
    }

    public static void readAscii(ByteBuffer src, StringBuilder builder) {
        Buffers.readAscii(src, builder, '?');
    }

    public static void readAscii(ByteBuffer src, StringBuilder builder, char replacement) {
        while (src.hasRemaining()) {
            byte b = src.get();
            builder.append(b < 0 ? replacement : (char)b);
        }
        return;
    }

    public static void readAscii(ByteBuffer src, StringBuilder builder, int limit, char replacement) {
        while (limit > 0) {
            if (!src.hasRemaining()) {
                return;
            }
            byte b = src.get();
            builder.append(b < 0 ? replacement : (char)b);
            --limit;
        }
    }

    public static boolean readLatin1Z(ByteBuffer src, StringBuilder builder) {
        while (src.hasRemaining()) {
            byte b = src.get();
            if (b == 0) {
                return true;
            }
            builder.append((char)(b & 0xFF));
        }
        return false;
    }

    public static boolean readLatin1Line(ByteBuffer src, StringBuilder builder) {
        byte b;
        do {
            if (!src.hasRemaining()) {
                return false;
            }
            b = src.get();
            builder.append((char)(b & 0xFF));
        } while (b != 10);
        return true;
    }

    public static boolean readLatin1Line(ByteBuffer src, StringBuilder builder, char delimiter) {
        byte b;
        do {
            if (!src.hasRemaining()) {
                return false;
            }
            b = src.get();
            builder.append((char)(b & 0xFF));
        } while (b != delimiter);
        return true;
    }

    public static void readLatin1(ByteBuffer src, StringBuilder builder) {
        while (src.hasRemaining()) {
            byte b = src.get();
            builder.append((char)(b & 0xFF));
        }
        return;
    }

    public static boolean readModifiedUtf8Z(ByteBuffer src, StringBuilder builder) {
        return Buffers.readModifiedUtf8Z(src, builder, '?');
    }

    public static boolean readModifiedUtf8Z(ByteBuffer src, StringBuilder builder, char replacement) {
        block10: {
            while (true) {
                int b;
                if (!src.hasRemaining()) {
                    return false;
                }
                int a = src.get() & 0xFF;
                if (a == 0) {
                    return true;
                }
                if (a < 128) {
                    builder.append((char)a);
                    continue;
                }
                if (a < 192) {
                    builder.append(replacement);
                    continue;
                }
                if (a < 224) {
                    if (src.hasRemaining()) {
                        b = src.get() & 0xFF;
                        if ((b & 0xC0) != 128) {
                            builder.append(replacement);
                            continue;
                        }
                        builder.append((char)((a & 0x1F) << 6 | b & 0x3F));
                        continue;
                    }
                    Buffers.unget(src, 1);
                    return false;
                }
                if (a >= 240) continue;
                if (!src.hasRemaining()) break block10;
                b = src.get() & 0xFF;
                if ((b & 0xC0) != 128) {
                    builder.append(replacement);
                    continue;
                }
                if (!src.hasRemaining()) break;
                int c = src.get() & 0xFF;
                if ((c & 0xC0) != 128) {
                    builder.append(replacement);
                    continue;
                }
                builder.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
            }
            Buffers.unget(src, 2);
            return false;
        }
        Buffers.unget(src, 1);
        return false;
    }

    public static boolean readModifiedUtf8Line(ByteBuffer src, StringBuilder builder) {
        return Buffers.readModifiedUtf8Line(src, builder, '?');
    }

    public static boolean readModifiedUtf8Line(ByteBuffer src, StringBuilder builder, char replacement) {
        return Buffers.readModifiedUtf8Line(src, builder, replacement, '\n');
    }

    public static boolean readModifiedUtf8Line(ByteBuffer src, StringBuilder builder, char replacement, char delimiter) {
        block9: {
            block10: {
                while (true) {
                    int b;
                    if (!src.hasRemaining()) {
                        return false;
                    }
                    int a = src.get() & 0xFF;
                    if (a < 128) {
                        builder.append((char)a);
                        if (a != delimiter) continue;
                        return true;
                    }
                    if (a < 192) {
                        builder.append(replacement);
                        continue;
                    }
                    if (a < 224) {
                        if (src.hasRemaining()) {
                            b = src.get() & 0xFF;
                            if ((b & 0xC0) != 128) {
                                builder.append(replacement);
                                continue;
                            }
                            char ch = (char)((a & 0x1F) << 6 | b & 0x3F);
                            builder.append(ch);
                            if (ch != delimiter) continue;
                            return true;
                        }
                        Buffers.unget(src, 1);
                        return false;
                    }
                    if (a >= 240) continue;
                    if (!src.hasRemaining()) break block9;
                    b = src.get() & 0xFF;
                    if ((b & 0xC0) != 128) {
                        builder.append(replacement);
                        continue;
                    }
                    if (!src.hasRemaining()) break block10;
                    int c = src.get() & 0xFF;
                    if ((c & 0xC0) != 128) {
                        builder.append(replacement);
                        continue;
                    }
                    char ch = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                    builder.append(ch);
                    if (ch == delimiter) break;
                }
                return true;
            }
            Buffers.unget(src, 2);
            return false;
        }
        Buffers.unget(src, 1);
        return false;
    }

    public static boolean readLine(ByteBuffer src, StringBuilder builder, CharsetDecoder decoder) {
        return Buffers.readLine(src, builder, decoder, '\n');
    }

    public static boolean readLine(ByteBuffer src, StringBuilder builder, CharsetDecoder decoder, char delimiter) {
        CharBuffer oneChar = CharBuffer.allocate(1);
        CoderResult coderResult;
        while (!(coderResult = decoder.decode(src, oneChar, false)).isUnderflow()) {
            if (oneChar.hasRemaining()) {
                throw new IllegalStateException();
            }
            char ch = oneChar.get(0);
            builder.append(ch);
            if (ch == delimiter) {
                return true;
            }
            oneChar.clear();
        }
        return false;
    }

    public static <B extends Buffer> Pooled<B> pooledWrapper(final B buffer) {
        return new Pooled<B>(){
            private volatile B buf;
            {
                this.buf = buffer;
            }

            @Override
            public void discard() {
                this.buf = null;
            }

            @Override
            public void free() {
                this.buf = null;
            }

            @Override
            public B getResource() throws IllegalStateException {
                Object buffer2 = this.buf;
                if (buffer2 == null) {
                    throw new IllegalStateException();
                }
                return buffer2;
            }

            public String toString() {
                return "Pooled wrapper around " + buffer;
            }
        };
    }

    public static BufferAllocator<ByteBuffer> sliceAllocator(final ByteBuffer buffer) {
        return new BufferAllocator<ByteBuffer>(){

            @Override
            public ByteBuffer allocate(int size) throws IllegalArgumentException {
                return Buffers.slice(buffer, size);
            }
        };
    }

    public static <B extends Buffer> Pool<B> allocatedBufferPool(final BufferAllocator<B> allocator, final int size) {
        return new Pool<B>(){

            @Override
            public Pooled<B> allocate() {
                return Buffers.pooledWrapper(allocator.allocate(size));
            }
        };
    }

    public static Pool<ByteBuffer> secureBufferPool(Pool<ByteBuffer> delegate) {
        return new SecureByteBufferPool(delegate);
    }

    public static boolean isSecureBufferPool(Pool<?> pool) {
        return pool instanceof SecureByteBufferPool;
    }

    public static void zero(ByteBuffer buffer) {
        buffer.clear();
        while (buffer.remaining() >= 8) {
            buffer.putLong(0L);
        }
        while (buffer.hasRemaining()) {
            buffer.put((byte)0);
        }
        buffer.clear();
    }

    public static void zero(CharBuffer buffer) {
        buffer.clear();
        while (buffer.remaining() >= 32) {
            buffer.put("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        }
        while (buffer.hasRemaining()) {
            buffer.put('\u0000');
        }
        buffer.clear();
    }

    public static boolean isDirect(Buffer ... buffers) throws IllegalArgumentException {
        return Buffers.isDirect(buffers, 0, buffers.length);
    }

    public static boolean isDirect(Buffer[] buffers, int offset, int length) {
        boolean foundDirect = false;
        boolean foundHeap = false;
        for (int i = 0; i < length; ++i) {
            Buffer buffer = buffers[i + offset];
            if (buffer == null) {
                throw new IllegalArgumentException("buffer is null");
            }
            if (buffer.isDirect()) {
                if (foundHeap) {
                    throw new IllegalArgumentException("Mixed direct and heap buffers");
                }
                foundDirect = true;
                continue;
            }
            if (foundDirect) {
                throw new IllegalArgumentException("Mixed direct and heap buffers");
            }
            foundHeap = true;
        }
        return foundDirect;
    }

    public static void assertWritable(Buffer[] buffers, int offs, int len) throws ReadOnlyBufferException {
        for (int i = 0; i < len; ++i) {
            if (!buffers[i + offs].isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
    }

    public static void assertWritable(Buffer ... buffers) throws ReadOnlyBufferException {
        Buffers.assertWritable(buffers, 0, buffers.length);
    }

    public static void addRandom(ByteBuffer target, Random random, int count) {
        byte[] bytes = new byte[count];
        random.nextBytes(bytes);
        target.put(bytes);
    }

    public static void addRandom(ByteBuffer target, int count) {
        Buffers.addRandom(target, IoUtils.getThreadLocalRandom(), count);
    }

    public static void addRandom(ByteBuffer target, Random random) {
        Buffers.addRandom(target, random, random.nextInt(target.remaining()));
    }

    public static void addRandom(ByteBuffer target) {
        Buffers.addRandom(target, IoUtils.getThreadLocalRandom());
    }

    private static class SecurePooledByteBuffer
    implements Pooled<ByteBuffer> {
        private static final AtomicIntegerFieldUpdater<SecurePooledByteBuffer> freedUpdater = AtomicIntegerFieldUpdater.newUpdater(SecurePooledByteBuffer.class, "freed");
        private final Pooled<ByteBuffer> allocated;
        private volatile int freed;

        SecurePooledByteBuffer(Pooled<ByteBuffer> allocated) {
            this.allocated = allocated;
        }

        @Override
        public void discard() {
            if (freedUpdater.compareAndSet(this, 0, 1)) {
                Buffers.zero(this.allocated.getResource());
                this.allocated.discard();
            }
        }

        @Override
        public void free() {
            if (freedUpdater.compareAndSet(this, 0, 1)) {
                Buffers.zero(this.allocated.getResource());
                this.allocated.free();
            }
        }

        @Override
        public ByteBuffer getResource() throws IllegalStateException {
            return this.allocated.getResource();
        }

        public String toString() {
            return "Secure wrapper around " + this.allocated;
        }
    }

    private static class SecureByteBufferPool
    implements Pool<ByteBuffer> {
        private final Pool<ByteBuffer> delegate;

        SecureByteBufferPool(Pool<ByteBuffer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Pooled<ByteBuffer> allocate() {
            return new SecurePooledByteBuffer(this.delegate.allocate());
        }
    }
}

