/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.jpa.hibernate4.HibernateAnnotationScanner;
import org.jboss.as.jpa.hibernate4.JBossAppServerJtaPlatform;
import org.jboss.as.jpa.hibernate4.management.HibernateManagementAdaptor;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    private volatile JBossAppServerJtaPlatform appServerJtaPlatform;
    private final HibernateManagementAdaptor hibernateManagementAdaptor = new HibernateManagementAdaptor();

    public void injectJtaManager(JtaManager jtaManager) {
        this.appServerJtaPlatform = new JBossAppServerJtaPlatform(jtaManager);
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        this.putPropertyIfAbsent(properties, "hibernate.id.new_generator_mappings", "true");
        this.putPropertyIfAbsent(properties, "hibernate.ejb.resource_scanner", "org.jboss.as.jpa.hibernate4.HibernateAnnotationScanner");
        properties.put("hibernate.classLoader.application", pu.getClassLoader());
        this.putPropertyIfAbsent(properties, "hibernate.transaction.jta.platform", (Object)this.appServerJtaPlatform);
        properties.remove("hibernate.transaction.manager_lookup_class");
    }

    public Iterable<ServiceName> getProviderDependencies(PersistenceUnitMetadata pu) {
        String cacheManager = pu.getProperties().getProperty("hibernate.cache.infinispan.cachemanager");
        String useCache = pu.getProperties().getProperty("hibernate.cache.use_second_level_cache");
        String regionFactoryClass = pu.getProperties().getProperty("hibernate.cache.region.factory_class");
        if (useCache != null && useCache.equalsIgnoreCase("true") || cacheManager != null) {
            if (regionFactoryClass == null) {
                regionFactoryClass = "org.hibernate.cache.infinispan.JndiInfinispanRegionFactory";
                pu.getProperties().put("hibernate.cache.region.factory_class", regionFactoryClass);
            }
            if (cacheManager == null) {
                cacheManager = "java:jboss/infinispan/hibernate";
                pu.getProperties().put("hibernate.cache.infinispan.cachemanager", cacheManager);
            }
            if (pu.getProperties().getProperty("hibernate.cache.region_prefix") == null) {
                pu.getProperties().put("hibernate.cache.region_prefix", pu.getScopedPersistenceUnitName());
            }
            ArrayList<ServiceName> result = new ArrayList<ServiceName>();
            result.add(this.adjustJndiName(cacheManager));
            return result;
        }
        return null;
    }

    private void putPropertyIfAbsent(Map properties, String property, Object value) {
        if (!properties.containsKey(property)) {
            properties.put(property, value);
        }
    }

    private ServiceName adjustJndiName(String jndiName) {
        jndiName = HibernatePersistenceProviderAdaptor.toJndiName(jndiName).toString();
        return ContextNames.bindInfoFor((String)jndiName).getBinderServiceName();
    }

    private static JndiName toJndiName(String value) {
        return value.startsWith("java:") ? JndiName.of((String)value) : JndiName.of((String)"java:jboss").append(value.startsWith("/") ? value.substring(1) : value);
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.setThreadLocalPersistenceUnitMetadata(pu);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.clearThreadLocalPersistenceUnitMetadata();
    }

    public ManagementAdaptor getManagementAdaptor() {
        return this.hibernateManagementAdaptor;
    }
}

