/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.hibernate.stat.Statistics;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jpa.hibernate4.management.ManagementLookup;
import org.jboss.as.jpa.hibernate4.management.QueryName;
import org.jboss.as.jpa.spi.PersistenceUnitService;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelNode;

public class HibernateStatisticsResource
extends PlaceholderResource.PlaceholderResourceEntry {
    private final String puName;
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;
    private final ModelNode model = new ModelNode();
    private final String providerLabel;

    public HibernateStatisticsResource(String puName, PersistenceUnitServiceRegistry persistenceUnitRegistry, String providerLabel) {
        super(providerLabel, puName);
        this.puName = puName;
        this.persistenceUnitRegistry = persistenceUnitRegistry;
        this.providerLabel = providerLabel;
    }

    public ModelNode getModel() {
        return this.model;
    }

    public boolean isModelDefined() {
        return this.model.isDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("entity-cache".equals(element.getKey())) {
            return this.hasCacheRegion(element);
        }
        if ("entity".equals(element.getKey())) {
            return this.hasEntity(element);
        }
        if ("collection".equals(element.getKey())) {
            return this.hasCollection(element);
        }
        if ("query-cache".equals(element.getKey())) {
            return this.hasQuery(element);
        }
        return super.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("entity-cache".equals(element.getKey())) {
            return this.hasCacheRegion(element) ? PlaceholderResource.INSTANCE : null;
        }
        if ("entity".equals(element.getKey())) {
            return this.hasEntity(element) ? PlaceholderResource.INSTANCE : null;
        }
        if ("collection".equals(element.getKey())) {
            return this.hasCollection(element) ? PlaceholderResource.INSTANCE : null;
        }
        if ("query-cache".equals(element.getKey())) {
            return this.hasQuery(element) ? PlaceholderResource.INSTANCE : null;
        }
        return super.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("entity-cache".equals(element.getKey())) {
            if (this.hasCacheRegion(element)) {
                return PlaceholderResource.INSTANCE;
            }
            throw new NoSuchElementException(element.toString());
        }
        if ("entity".equals(element.getKey())) {
            if (this.hasEntity(element)) {
                return PlaceholderResource.INSTANCE;
            }
            throw new NoSuchElementException(element.toString());
        }
        if ("collection".equals(element.getKey())) {
            if (this.hasCollection(element)) {
                return PlaceholderResource.INSTANCE;
            }
            throw new NoSuchElementException(element.toString());
        }
        if ("query-cache".equals(element.getKey())) {
            if (this.hasQuery(element)) {
                return PlaceholderResource.INSTANCE;
            }
            throw new NoSuchElementException(element.toString());
        }
        return super.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("entity-cache".equals(childType)) {
            return this.getChildrenNames("entity-cache").size() > 0;
        }
        if ("entity".equals(childType)) {
            return this.getChildrenNames("entity").size() > 0;
        }
        if ("collection".equals(childType)) {
            return this.getChildrenNames("collection").size() > 0;
        }
        if ("query-cache".equals(childType)) {
            return this.getChildrenNames("query-cache").size() > 0;
        }
        return super.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "entity-cache".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new NoSuchElementException(address.subAddress(1).toString());
            }
            return PlaceholderResource.INSTANCE;
        }
        if (address.size() > 0 && "entity".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new NoSuchElementException(address.subAddress(1).toString());
            }
            return PlaceholderResource.INSTANCE;
        }
        if (address.size() > 0 && "collection".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new NoSuchElementException(address.subAddress(1).toString());
            }
            return PlaceholderResource.INSTANCE;
        }
        if (address.size() > 0 && "query-cache".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new NoSuchElementException(address.subAddress(1).toString());
            }
            return PlaceholderResource.INSTANCE;
        }
        return super.navigate(address);
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>(super.getChildTypes());
        result.add("entity-cache");
        result.add("entity");
        result.add("collection");
        result.add("query-cache");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("entity-cache".equals(childType)) {
            return this.getCacheRegionNames();
        }
        if ("entity".equals(childType)) {
            return this.getEntityNames();
        }
        if ("collection".equals(childType)) {
            return this.getCollectionNames();
        }
        if ("query-cache".equals(childType)) {
            return this.getQueryNames();
        }
        return super.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("entity-cache".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getCacheRegionNames()) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("entity-cache", name));
            }
            return result;
        }
        if ("entity".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getEntityNames()) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("entity", name));
            }
            return result;
        }
        if ("collection".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getCollectionNames()) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("collection", name));
            }
            return result;
        }
        if ("query-cache".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getQueryNames()) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("query-cache", name));
            }
            return result;
        }
        return super.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        if ("entity-cache".equals(address.getKey()) || "entity".equals(address.getKey()) || "collection".equals(address.getKey()) || "query-cache".equals(address.getKey())) {
            throw new UnsupportedOperationException(String.format("Resources of type %s cannot be registered", address.getKey()));
        }
        super.registerChild(address, resource);
    }

    public Resource removeChild(PathElement address) {
        if ("entity-cache".equals(address.getKey()) || "entity".equals(address.getKey()) || "collection".equals(address.getKey()) || "query-cache".equals(address.getKey())) {
            throw new UnsupportedOperationException(String.format("Resources of type %s cannot be removed", address.getKey()));
        }
        return super.removeChild(address);
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public HibernateStatisticsResource clone() {
        return new HibernateStatisticsResource(this.puName, this.persistenceUnitRegistry, this.providerLabel);
    }

    private boolean hasEntity(PathElement element) {
        boolean result = false;
        Statistics stats = this.getStatistics();
        if (stats != null) {
            String emtityName = element.getValue();
            result = stats.getEntityStatistics(emtityName) != null;
        }
        return result;
    }

    private Set<String> getEntityNames() {
        Statistics stats = this.getStatistics();
        if (stats == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        String[] entityNames = stats.getEntityNames();
        if (entityNames != null) {
            for (String entity : entityNames) {
                result.add(entity);
            }
        }
        return result;
    }

    private boolean hasCacheRegion(PathElement element) {
        boolean result = false;
        PersistenceUnitService puService = this.persistenceUnitRegistry.getPersistenceUnitService(this.puName);
        Statistics stats = this.getStatistics();
        if (stats != null && puService != null) {
            String scopedPUName = puService.getScopedPersistenceUnitName();
            String unqualifiedRegionName = element.getValue();
            String qualifiedRegionName = scopedPUName + "." + unqualifiedRegionName;
            result = stats.getSecondLevelCacheStatistics(qualifiedRegionName) != null;
        }
        return result;
    }

    private Set<String> getCacheRegionNames() {
        Statistics stats = this.getStatistics();
        if (stats == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        String[] cacheRegionNames = stats.getSecondLevelCacheRegionNames();
        if (cacheRegionNames != null) {
            for (String region : cacheRegionNames) {
                int stripUpTo = this.puName.length() + 1;
                result.add(region.substring(stripUpTo));
            }
        }
        return result;
    }

    private boolean hasQuery(PathElement element) {
        boolean result = false;
        PersistenceUnitService puService = this.persistenceUnitRegistry.getPersistenceUnitService(this.puName);
        Statistics stats = this.getStatistics();
        if (stats != null && puService != null) {
            String scopedPUName = puService.getScopedPersistenceUnitName();
            String unqualifiedQueryName = element.getValue();
            String queryName = scopedPUName + "." + unqualifiedQueryName;
            result = stats.getQueryStatistics(queryName) != null;
        }
        return result;
    }

    private Set<String> getQueryNames() {
        Statistics stats = this.getStatistics();
        if (stats == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        String[] queries = stats.getQueries();
        if (queries != null) {
            for (String query : queries) {
                result.add(QueryName.queryName(query).getDisplayName());
            }
        }
        return result;
    }

    private boolean hasCollection(PathElement element) {
        boolean result = false;
        Statistics stats = this.getStatistics();
        if (stats != null) {
            String collectionName = element.getValue();
            result = stats.getCollectionStatistics(collectionName) != null;
        }
        return result;
    }

    private Set<String> getCollectionNames() {
        Statistics stats = this.getStatistics();
        if (stats == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        String[] collectionNames = stats.getCollectionRoleNames();
        if (collectionNames != null) {
            for (String entity : collectionNames) {
                result.add(entity);
            }
        }
        return result;
    }

    private Statistics getStatistics() {
        ManagementLookup stats = ManagementLookup.create(this.persistenceUnitRegistry, this.puName);
        if (stats != null) {
            return stats.getStatistics();
        }
        return null;
    }
}

