/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.clienttoken;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.SaslException;
import org.jboss.sasl.callback.TokenCallback;
import org.jboss.sasl.util.AbstractSaslClient;
import org.jboss.sasl.util.Charsets;
import org.jboss.sasl.util.SaslState;
import org.jboss.sasl.util.SaslStateContext;

public final class ClientTokenSaslClient
extends AbstractSaslClient {
    private final SaslState initial = new SaslState(){

        @Override
        public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
            if (message != null && message.length > 0) {
                throw new SaslException("Invalid challenge received from server");
            }
            NameCallback nameCallback = new NameCallback("Authentication name");
            TokenCallback tokenCallback = new TokenCallback("Authentication token", 16);
            ClientTokenSaslClient.this.handleCallbacks(new Callback[]{nameCallback, tokenCallback});
            String name = nameCallback.getName();
            if (name == null) {
                throw new SaslException("Authentication name is missing");
            }
            if (name.length() > 255) {
                throw new SaslException("Authentication name string is too long");
            }
            if (name.isEmpty()) {
                throw new SaslException("Authentication name is empty");
            }
            byte[] token = tokenCallback.getToken();
            if (token.length != 16) {
                throw new SaslException("Authentication token is not the correct length");
            }
            byte[] bytes = name.getBytes(Charsets.UTF_8);
            byte[] out = new byte[1 + token.length + 1 + bytes.length];
            out[0] = 16;
            System.arraycopy(token, 0, out, 1, 16);
            out[17] = (byte)bytes.length;
            System.arraycopy(bytes, 0, out, 18, bytes.length);
            context.negotiationComplete();
            return out;
        }
    };

    public ClientTokenSaslClient(String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId) {
        super("CLIENT-TOKEN", protocol, serverName, callbackHandler, authorizationId, true);
        this.getContext().setNegotiationState(this.initial);
    }
}

