/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.IOCompletion;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.LoaderCallback;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.TestableJournal;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.AbstractJournalUpdateTask;
import org.hornetq.core.journal.impl.DummyCallback;
import org.hornetq.core.journal.impl.JournalCompactor;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalFileImpl;
import org.hornetq.core.journal.impl.JournalFilesRepository;
import org.hornetq.core.journal.impl.JournalReaderCallback;
import org.hornetq.core.journal.impl.JournalRecord;
import org.hornetq.core.journal.impl.JournalRecordProvider;
import org.hornetq.core.journal.impl.JournalTransaction;
import org.hornetq.core.journal.impl.Reclaimer;
import org.hornetq.core.journal.impl.SimpleWaitIOCallback;
import org.hornetq.core.journal.impl.SyncIOCompletion;
import org.hornetq.core.journal.impl.TransactionCallback;
import org.hornetq.core.journal.impl.dataformat.ByteArrayEncoding;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecord;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecord;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;
import org.hornetq.core.journal.impl.dataformat.JournalRollbackRecordTX;
import org.hornetq.core.logging.Logger;

public class JournalImpl
implements TestableJournal,
JournalRecordProvider {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_LOADED = 2;
    public static final int FORMAT_VERSION = 2;
    private static final int[] COMPATIBLE_VERSIONS = new int[]{1};
    private static final Logger log = Logger.getLogger(JournalImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean TRACE_RECORDS = false;
    public static final int MIN_FILE_SIZE = 1024;
    public static final int SIZE_HEADER = 16;
    public static final int BASIC_SIZE = 9;
    public static final int SIZE_ADD_RECORD = 22;
    public static final byte ADD_RECORD = 11;
    public static final byte UPDATE_RECORD = 12;
    public static final int SIZE_ADD_RECORD_TX = 30;
    public static final byte ADD_RECORD_TX = 13;
    public static final byte UPDATE_RECORD_TX = 14;
    public static final int SIZE_DELETE_RECORD_TX = 29;
    public static final byte DELETE_RECORD_TX = 15;
    public static final int SIZE_DELETE_RECORD = 17;
    public static final byte DELETE_RECORD = 16;
    public static final int SIZE_COMPLETE_TRANSACTION_RECORD = 21;
    public static final int SIZE_PREPARE_RECORD = 25;
    public static final byte PREPARE_RECORD = 17;
    public static final int SIZE_COMMIT_RECORD = 21;
    public static final byte COMMIT_RECORD = 18;
    public static final int SIZE_ROLLBACK_RECORD = 17;
    public static final byte ROLLBACK_RECORD = 19;
    public static final byte FILL_CHARACTER = 74;
    private volatile boolean autoReclaim = true;
    private final int userVersion;
    private final int fileSize;
    private final int minFiles;
    private final float compactPercentage;
    private final int compactMinFiles;
    private final SequentialFileFactory fileFactory;
    private final JournalFilesRepository filesRepository;
    private final ConcurrentMap<Long, JournalRecord> records = new ConcurrentHashMap<Long, JournalRecord>();
    private final ConcurrentMap<Long, JournalTransaction> transactions = new ConcurrentHashMap<Long, JournalTransaction>();
    private volatile JournalCompactor compactor;
    private final AtomicBoolean compactorRunning = new AtomicBoolean();
    private ExecutorService filesExecutor = null;
    private ExecutorService compactorExecutor = null;
    private final ReentrantLock lockAppend = new ReentrantLock();
    private final ReadWriteLock compactingLock = new ReentrantReadWriteLock();
    private volatile JournalFile currentFile;
    private volatile int state;
    private final Reclaimer reclaimer = new Reclaimer();

    private static final void trace(String message) {
        log.trace(message);
    }

    private static final void traceRecord(String message) {
        log.trace(message);
    }

    public JournalImpl(int fileSize, int minFiles, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO) {
        this(fileSize, minFiles, compactMinFiles, compactPercentage, fileFactory, filePrefix, fileExtension, maxAIO, 0);
    }

    public JournalImpl(int fileSize, int minFiles, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO, int userVersion) {
        if (fileFactory == null) {
            throw new NullPointerException("fileFactory is null");
        }
        if (fileSize < 1024) {
            throw new IllegalArgumentException("File size cannot be less than 1024 bytes");
        }
        if (fileSize % fileFactory.getAlignment() != 0) {
            throw new IllegalArgumentException("Invalid journal-file-size " + fileSize + ", It should be multiple of " + fileFactory.getAlignment());
        }
        if (minFiles < 2) {
            throw new IllegalArgumentException("minFiles cannot be less than 2");
        }
        if (filePrefix == null) {
            throw new NullPointerException("filePrefix is null");
        }
        if (fileExtension == null) {
            throw new NullPointerException("fileExtension is null");
        }
        if (maxAIO <= 0) {
            throw new IllegalStateException("maxAIO should aways be a positive number");
        }
        if (compactPercentage < 0 || compactPercentage > 100) {
            throw new IllegalArgumentException("Compact Percentage out of range");
        }
        this.compactPercentage = compactPercentage == 0 ? 0.0f : (float)compactPercentage / 100.0f;
        this.compactMinFiles = compactMinFiles;
        this.fileSize = fileSize;
        this.minFiles = minFiles;
        this.fileFactory = fileFactory;
        this.filesRepository = new JournalFilesRepository(fileFactory, this, filePrefix, fileExtension, userVersion, maxAIO, fileSize, minFiles);
        this.userVersion = userVersion;
    }

    @Override
    public void runDirectJournalBlast() throws Exception {
        int numIts = 100000000;
        log.info("*** running direct journal blast: 100000000");
        final CountDownLatch latch = new CountDownLatch(200000000);
        class MyIOAsyncTask
        implements IOCompletion {
            MyIOAsyncTask() {
            }

            @Override
            public void done() {
                latch.countDown();
            }

            @Override
            public void onError(int errorCode, String errorMessage) {
            }

            @Override
            public void storeLineUp() {
            }
        }
        MyIOAsyncTask task = new MyIOAsyncTask();
        int recordSize = 1024;
        final byte[] bytes = new byte[1024];
        class MyRecord
        implements EncodingSupport {
            MyRecord() {
            }

            @Override
            public void decode(HornetQBuffer buffer) {
            }

            @Override
            public void encode(HornetQBuffer buffer) {
                buffer.writeBytes(bytes);
            }

            @Override
            public int getEncodeSize() {
                return 1024;
            }
        }
        MyRecord record = new MyRecord();
        for (int i = 0; i < 100000000; ++i) {
            this.appendAddRecord((long)i, (byte)1, record, true, (IOCompletion)task);
            this.appendDeleteRecord(i, true, task);
        }
        latch.await();
    }

    @Override
    public Map<Long, JournalRecord> getRecords() {
        return this.records;
    }

    @Override
    public JournalFile getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public JournalCompactor getCompactor() {
        return this.compactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JournalFile> orderFiles() throws Exception {
        List<String> fileNames = this.fileFactory.listFiles(this.filesRepository.getFileExtension());
        ArrayList<JournalFile> orderedFiles = new ArrayList<JournalFile>(fileNames.size());
        for (String fileName : fileNames) {
            SequentialFile file = this.fileFactory.createSequentialFile(fileName, this.filesRepository.getMaxAIO());
            file.open(1, false);
            try {
                JournalFileImpl jrnFile = this.readFileHeader(file);
                orderedFiles.add(jrnFile);
            }
            finally {
                file.close();
            }
        }
        Collections.sort(orderedFiles, new JournalFileComparator());
        return orderedFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readJournalFile(SequentialFileFactory fileFactory, JournalFile file, JournalReaderCallback reader) throws Exception {
        int n;
        file.getFile().open(1, false);
        ByteBuffer wholeFileBuffer = null;
        try {
            int filesize = (int)file.getFile().size();
            wholeFileBuffer = fileFactory.newBuffer(filesize);
            int journalFileSize = file.getFile().read(wholeFileBuffer);
            if (journalFileSize != filesize) {
                throw new RuntimeException("Invalid read! The system couldn't read the entire file into memory");
            }
            wholeFileBuffer.position(16);
            int lastDataPos = 16;
            while (wholeFileBuffer.hasRemaining()) {
                int recordSize;
                int pos = wholeFileBuffer.position();
                byte recordType = wholeFileBuffer.get();
                if (recordType < 11 || recordType > 19) continue;
                if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                int readFileId = wholeFileBuffer.getInt();
                if (readFileId != file.getRecordID()) {
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                short compactCount = 0;
                if (file.getJournalVersion() >= 2) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 1)) {
                        reader.markAsDataFile(file);
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    compactCount = wholeFileBuffer.get();
                }
                long transactionID = 0L;
                if (JournalImpl.isTransaction(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    transactionID = wholeFileBuffer.getLong();
                }
                long recordID = 0L;
                if (!JournalImpl.isCompleteTransaction(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    recordID = wholeFileBuffer.getLong();
                }
                int variableSize = 0;
                int preparedTransactionExtraDataSize = 0;
                byte userRecordType = 0;
                byte[] record = null;
                if (JournalImpl.isContainsBody(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    variableSize = wholeFileBuffer.getInt();
                    if (recordType != 15) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 1)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        userRecordType = wholeFileBuffer.get();
                    }
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), variableSize)) {
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    record = new byte[variableSize];
                    wholeFileBuffer.get(record);
                }
                int transactionCheckNumberOfRecords = 0;
                if (recordType == 17 || recordType == 18) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    transactionCheckNumberOfRecords = wholeFileBuffer.getInt();
                    if (recordType == 17) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        preparedTransactionExtraDataSize = wholeFileBuffer.getInt();
                    }
                    variableSize = 0;
                }
                if (JournalImpl.isInvalidSize(journalFileSize, pos, (recordSize = JournalImpl.getRecordSize(recordType, file.getJournalVersion())) + variableSize + preparedTransactionExtraDataSize)) {
                    JournalImpl.trace("Record at position " + pos + " recordType = " + recordType + " file:" + file.getFile().getFileName() + " recordSize: " + recordSize + " variableSize: " + variableSize + " preparedTransactionExtraDataSize: " + preparedTransactionExtraDataSize + " is corrupted and it is being ignored (II)");
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                int oldPos = wholeFileBuffer.position();
                wholeFileBuffer.position(pos + variableSize + recordSize + preparedTransactionExtraDataSize - 4);
                int checkSize = wholeFileBuffer.getInt();
                if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                    JournalImpl.trace("Record at position " + pos + " recordType = " + recordType + " possible transactionID = " + transactionID + " possible recordID = " + recordID + " file:" + file.getFile().getFileName() + " is corrupted and it is being ignored (III)");
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                wholeFileBuffer.position(oldPos);
                switch (recordType) {
                    case 11: {
                        reader.onReadAddRecord(new RecordInfo(recordID, userRecordType, record, false, compactCount));
                        break;
                    }
                    case 12: {
                        reader.onReadUpdateRecord(new RecordInfo(recordID, userRecordType, record, true, compactCount));
                        break;
                    }
                    case 16: {
                        reader.onReadDeleteRecord(recordID);
                        break;
                    }
                    case 13: {
                        reader.onReadAddRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, false, compactCount));
                        break;
                    }
                    case 14: {
                        reader.onReadUpdateRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, true, compactCount));
                        break;
                    }
                    case 15: {
                        reader.onReadDeleteRecordTX(transactionID, new RecordInfo(recordID, 0, record, true, compactCount));
                        break;
                    }
                    case 17: {
                        byte[] extraData = new byte[preparedTransactionExtraDataSize];
                        wholeFileBuffer.get(extraData);
                        reader.onReadPrepareRecord(transactionID, extraData, transactionCheckNumberOfRecords);
                        break;
                    }
                    case 18: {
                        reader.onReadCommitRecord(transactionID, transactionCheckNumberOfRecords);
                        break;
                    }
                    case 19: {
                        reader.onReadRollbackRecord(transactionID);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Journal " + file.getFile().getFileName() + " is corrupt, invalid record type " + recordType);
                    }
                }
                checkSize = wholeFileBuffer.getInt();
                if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                    throw new IllegalStateException("Internal error on loading file. Position doesn't match with checkSize, file = " + file.getFile() + ", pos = " + pos);
                }
                lastDataPos = wholeFileBuffer.position();
            }
            n = lastDataPos;
            if (wholeFileBuffer != null) {
                fileFactory.releaseBuffer(wholeFileBuffer);
            }
        }
        catch (Throwable e) {
            try {
                log.warn(e.getMessage(), e);
                throw new Exception(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (wholeFileBuffer != null) {
                    fileFactory.releaseBuffer(wholeFileBuffer);
                }
                try {
                    file.getFile().close();
                    throw throwable;
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            file.getFile().close();
            return n;
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync, IOCompletion callback) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync, callback);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendAddRecord(id, recordType, record, sync, (IOCompletion)callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalAddRecord addRecord = new JournalAddRecord(true, id, recordType, record);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(addRecord, false, sync, null, callback);
                this.records.put(id, new JournalRecord(usedFile, ((JournalInternalRecord)addRecord).getEncodeSize()));
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync, IOCompletion callback) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync, callback);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendUpdateRecord(id, recordType, record, sync, (IOCompletion)callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalRecord jrnRecord = (JournalRecord)this.records.get(id);
            if (!(jrnRecord != null || this.compactor != null && this.compactor.lookupRecord(id))) {
                throw new IllegalStateException("Cannot find add info " + id);
            }
            JournalAddRecord updateRecord = new JournalAddRecord(false, id, recordType, record);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(updateRecord, false, sync, null, callback);
                if (jrnRecord == null) {
                    this.compactor.addCommandUpdate(id, usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize());
                } else {
                    jrnRecord.addUpdateFile(usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize());
                }
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        SyncIOCompletion callback = this.getSyncCallback(sync);
        this.appendDeleteRecord(id, sync, callback);
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalRecord record = null;
            if (this.compactor == null) {
                record = (JournalRecord)this.records.remove(id);
                if (record == null) {
                    throw new IllegalStateException("Cannot find add info " + id);
                }
            } else if (!this.records.containsKey(id) && !this.compactor.lookupRecord(id)) {
                throw new IllegalStateException("Cannot find add info " + id + " on compactor or current records");
            }
            JournalDeleteRecord deleteRecord = new JournalDeleteRecord(id);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(deleteRecord, false, sync, null, callback);
                if (record == null) {
                    this.compactor.addCommandDelete(id, usedFile);
                } else {
                    record.delete(usedFile);
                }
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalAddRecordTX addRecord = new JournalAddRecordTX(true, txID, id, recordType, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(addRecord, false, false, tx, null);
                tx.addPositive(usedFile, id, ((JournalInternalRecord)addRecord).getEncodeSize());
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, txID, id, recordType, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(updateRecordTX, false, false, tx, null);
                tx.addPositive(usedFile, id, ((JournalInternalRecord)updateRecordTX).getEncodeSize());
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, new ByteArrayEncoding(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        try {
            JournalDeleteRecordTX deleteRecordTX = new JournalDeleteRecordTX(txID, id, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(deleteRecordTX, false, false, tx, null);
                tx.addNegative(usedFile, id);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, NullEncoding.instance);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync, IOCompletion completion) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync, completion);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendPrepareRecord(txID, transactionData, sync, (IOCompletion)syncCompletion);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        JournalTransaction tx = this.getTransactionInfo(txID);
        try {
            JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(false, txID, transactionData);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(prepareRecord, true, sync, tx, callback);
                tx.prepare(usedFile);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendCommitRecord(txID, sync, syncCompletion, true);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    @Override
    public void lineUpContex(IOCompletion callback) {
        callback.storeLineUp();
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.appendCommitRecord(txID, sync, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        JournalTransaction tx = (JournalTransaction)this.transactions.remove(txID);
        try {
            if (tx == null) {
                throw new IllegalStateException("Cannot find tx with id " + txID);
            }
            JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(true, txID, null);
            if (callback != null && lineUpContext) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(commitRecord, true, sync, tx, callback);
                tx.commit(usedFile);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        SyncIOCompletion syncCompletion = this.getSyncCallback(sync);
        this.appendRollbackRecord(txID, sync, syncCompletion);
        if (syncCompletion != null) {
            syncCompletion.waitCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        if (this.state != 2) {
            throw new IllegalStateException("Journal must be loaded first");
        }
        this.compactingLock.readLock().lock();
        JournalTransaction tx = null;
        try {
            tx = (JournalTransaction)this.transactions.remove(txID);
            if (tx == null) {
                throw new IllegalStateException("Cannot find tx with id " + txID);
            }
            JournalRollbackRecordTX rollbackRecord = new JournalRollbackRecordTX(txID);
            if (callback != null) {
                callback.storeLineUp();
            }
            this.lockAppend.lock();
            try {
                JournalFile usedFile = this.appendRecord(rollbackRecord, false, sync, tx, callback);
                tx.rollback(usedFile);
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public int getAlignment() throws Exception {
        return this.fileFactory.getAlignment();
    }

    @Override
    public synchronized JournalLoadInformation loadInternalOnly() throws Exception {
        LoaderCallback dummyLoader = new LoaderCallback(){

            @Override
            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }

            @Override
            public void updateRecord(RecordInfo info) {
            }

            @Override
            public void deleteRecord(long id) {
            }

            @Override
            public void addRecord(RecordInfo info) {
            }

            @Override
            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
            }
        };
        return this.load(dummyLoader);
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback failureCallback) throws Exception {
        return this.load(committedRecords, preparedTransactions, failureCallback, true);
    }

    public synchronized JournalLoadInformation load(List<RecordInfo> committedRecords, final List<PreparedTransactionInfo> preparedTransactions, final TransactionFailureCallback failureCallback, boolean changeData) throws Exception {
        final HashSet recordsToDelete = new HashSet();
        final LinkedList records = new LinkedList();
        int DELETE_FLUSH = 20000;
        JournalLoadInformation info = this.load(new LoaderCallback(){
            Runtime runtime = Runtime.getRuntime();

            private void checkDeleteSize() {
                if (recordsToDelete.size() > 20000 && (double)this.runtime.freeMemory() < (double)this.runtime.maxMemory() * 0.2) {
                    log.debug("Flushing deletes during loading, deleteCount = " + recordsToDelete.size());
                    Iterator iter = records.iterator();
                    while (iter.hasNext()) {
                        RecordInfo record = (RecordInfo)iter.next();
                        if (!recordsToDelete.contains(record.id)) continue;
                        iter.remove();
                    }
                    recordsToDelete.clear();
                    log.debug("flush delete done");
                }
            }

            @Override
            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
                preparedTransactions.add(preparedTransaction);
                this.checkDeleteSize();
            }

            @Override
            public void addRecord(RecordInfo info) {
                records.add(info);
                this.checkDeleteSize();
            }

            @Override
            public void updateRecord(RecordInfo info) {
                records.add(info);
                this.checkDeleteSize();
            }

            @Override
            public void deleteRecord(long id) {
                recordsToDelete.add(id);
                this.checkDeleteSize();
            }

            @Override
            public void failedTransaction(long transactionID, List<RecordInfo> records2, List<RecordInfo> recordsToDelete2) {
                if (failureCallback != null) {
                    failureCallback.failedTransaction(transactionID, records2, recordsToDelete2);
                }
            }
        }, changeData);
        for (RecordInfo record : records) {
            if (recordsToDelete.contains(record.id)) continue;
            committedRecords.add(record);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testCompact() throws Exception {
        final AtomicInteger errors = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(1);
        this.compactorRunning.set(true);
        this.compactorExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JournalImpl.this.compact();
                }
                catch (Throwable e) {
                    errors.incrementAndGet();
                    log.error(e.getMessage(), e);
                    e.printStackTrace();
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            if (!latch.await(60L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Didn't finish compact timely");
            }
            if (errors.get() > 0) {
                throw new RuntimeException("Error during testCompact, look at the logs");
            }
        }
        finally {
            this.compactorRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void compact() throws Exception {
        if (this.compactor != null) {
            throw new IllegalStateException("There is pending compacting operation");
        }
        ArrayList<JournalFile> dataFilesToProcess = new ArrayList<JournalFile>(this.filesRepository.getDataFilesCount());
        boolean previousReclaimValue = this.autoReclaim;
        try {
            log.debug("Starting compacting operation on journal");
            this.onCompactStart();
            this.compactingLock.writeLock().lock();
            try {
                if (this.state != 2) {
                    return;
                }
                this.onCompactLock();
                this.setAutoReclaim(false);
                this.moveNextFile(false);
                dataFilesToProcess.addAll(this.filesRepository.getDataFiles());
                this.filesRepository.clearDataFiles();
                if (dataFilesToProcess.size() == 0) {
                    JournalImpl.trace("Finishing compacting, nothing to process");
                    return;
                }
                this.compactor = new JournalCompactor(this.fileFactory, this, this.filesRepository, this.records.keySet(), ((JournalFile)dataFilesToProcess.get(0)).getFileID());
                for (Map.Entry entry : this.transactions.entrySet()) {
                    this.compactor.addPendingTransaction((Long)entry.getKey(), ((JournalTransaction)entry.getValue()).getPositiveArray());
                    ((JournalTransaction)entry.getValue()).setCompacting();
                }
                this.records.clear();
            }
            finally {
                this.compactingLock.writeLock().unlock();
            }
            Collections.sort(dataFilesToProcess, new JournalFileComparator());
            for (JournalFile file : dataFilesToProcess) {
                try {
                    JournalImpl.readJournalFile(this.fileFactory, file, this.compactor);
                }
                catch (Throwable e) {
                    log.warn("Error on reading compacting for " + file);
                    throw new Exception("Error on reading compacting for " + file, e);
                }
            }
            this.compactor.flush();
            this.onCompactDone();
            List<JournalFile> newDatafiles = null;
            JournalCompactor localCompactor = this.compactor;
            SequentialFile controlFile = this.createControlFile(dataFilesToProcess, this.compactor.getNewDataFiles(), null);
            this.compactingLock.writeLock().lock();
            try {
                this.compactor = null;
                this.onCompactLock();
                newDatafiles = localCompactor.getNewDataFiles();
                for (Map.Entry<Long, JournalRecord> newRecordEntry : localCompactor.getNewRecords().entrySet()) {
                    this.records.put(newRecordEntry.getKey(), newRecordEntry.getValue());
                }
                for (int i = newDatafiles.size() - 1; i >= 0; --i) {
                    JournalFile fileToAdd = newDatafiles.get(i);
                    if (trace) {
                        JournalImpl.trace("Adding file " + fileToAdd + " back as datafile");
                    }
                    this.filesRepository.addDataFileOnTop(fileToAdd);
                }
                if (trace) {
                    JournalImpl.trace("There are " + this.filesRepository.getDataFilesCount() + " datafiles Now");
                }
                for (JournalTransaction newTransaction : localCompactor.getNewTransactions().values()) {
                    newTransaction.replaceRecordProvider(this);
                }
                localCompactor.replayPendingCommands();
                for (JournalTransaction newTransaction : localCompactor.getNewTransactions().values()) {
                    JournalTransaction liveTransaction;
                    if (trace) {
                        JournalImpl.trace("Merging pending transaction " + newTransaction + " after compacting the journal");
                    }
                    if ((liveTransaction = (JournalTransaction)this.transactions.get(newTransaction.getId())) != null) {
                        liveTransaction.merge(newTransaction);
                        continue;
                    }
                    log.warn("Couldn't find tx=" + newTransaction.getId() + " to merge after compacting");
                }
            }
            finally {
                this.compactingLock.writeLock().unlock();
            }
            this.renameFiles(dataFilesToProcess, newDatafiles);
            this.deleteControlFile(controlFile);
            log.debug("Finished compacting on journal");
            return;
        }
        finally {
            if (this.compactor != null) {
                try {
                    this.compactor.flush();
                }
                catch (Throwable ignored) {}
                this.compactor = null;
            }
            this.autoReclaim = previousReclaimValue;
        }
    }

    @Override
    public JournalLoadInformation load(LoaderCallback loadManager) throws Exception {
        return this.load(loadManager, true);
    }

    public synchronized JournalLoadInformation load(final LoaderCallback loadManager, boolean changeData) throws Exception {
        if (this.state != 1) {
            throw new IllegalStateException("Journal must be in started state");
        }
        this.checkControlFile();
        this.records.clear();
        this.filesRepository.clear();
        this.transactions.clear();
        final LinkedHashMap loadTransactions = new LinkedHashMap();
        final List<JournalFile> orderedFiles = this.orderFiles();
        this.filesRepository.calculateNextfileID(orderedFiles);
        int lastDataPos = 16;
        final AtomicLong maxID = new AtomicLong(-1L);
        for (final JournalFile file : orderedFiles) {
            JournalImpl.trace("Loading file " + file.getFile().getFileName());
            final AtomicBoolean hasData = new AtomicBoolean(false);
            int resultLastPost = JournalImpl.readJournalFile(this.fileFactory, file, new JournalReaderCallback(){

                private void checkID(long id) {
                    if (id > maxID.longValue()) {
                        maxID.set(id);
                    }
                }

                @Override
                public void onReadAddRecord(RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.set(true);
                    loadManager.addRecord(info);
                    JournalImpl.this.records.put(info.id, new JournalRecord(file, info.data.length + 22 + 1));
                }

                @Override
                public void onReadUpdateRecord(RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.set(true);
                    loadManager.updateRecord(info);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.get(info.id);
                    if (posFiles != null) {
                        posFiles.addUpdateFile(file, info.data.length + 22 + 1);
                    }
                }

                @Override
                public void onReadDeleteRecord(long recordID) throws Exception {
                    hasData.set(true);
                    loadManager.deleteRecord(recordID);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.remove(recordID);
                    if (posFiles != null) {
                        posFiles.delete(file);
                    }
                }

                @Override
                public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadAddRecordTX(transactionID, info);
                }

                @Override
                public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordInfos.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, tnp);
                    }
                    tnp.addPositive(file, info.id, info.data.length + 30 + 1);
                }

                @Override
                public void onReadDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordsToDelete.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, tnp);
                    }
                    tnp.addNegative(file, info.id);
                }

                @Override
                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    boolean healthy;
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.prepared = true;
                    tx.extraData = extraData;
                    JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (journalTransaction == null) {
                        journalTransaction = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, journalTransaction);
                    }
                    if (healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords)) {
                        journalTransaction.prepare(file);
                    } else {
                        log.warn("Prepared transaction " + transactionID + " wasn't considered completed, it will be ignored");
                        tx.invalid = true;
                    }
                }

                @Override
                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    TransactionHolder tx = (TransactionHolder)loadTransactions.remove(transactionID);
                    if (tx != null) {
                        JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (journalTransaction == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        boolean healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords);
                        if (healthy) {
                            for (RecordInfo txRecord : tx.recordInfos) {
                                if (txRecord.isUpdate) {
                                    loadManager.updateRecord(txRecord);
                                    continue;
                                }
                                loadManager.addRecord(txRecord);
                            }
                            for (RecordInfo deleteValue : tx.recordsToDelete) {
                                loadManager.deleteRecord(deleteValue.id);
                            }
                            journalTransaction.commit(file);
                        } else {
                            log.warn("Transaction " + transactionID + " is missing elements so the transaction is being ignored");
                            journalTransaction.forget();
                        }
                        hasData.set(true);
                    }
                }

                @Override
                public void onReadRollbackRecord(long transactionID) throws Exception {
                    TransactionHolder tx = (TransactionHolder)loadTransactions.remove(transactionID);
                    if (tx != null) {
                        JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (tnp == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        tnp.rollback(file);
                        hasData.set(true);
                    }
                }

                @Override
                public void markAsDataFile(JournalFile file2) {
                    hasData.set(true);
                }
            });
            if (hasData.get()) {
                lastDataPos = resultLastPost;
                this.filesRepository.addDataFileOnBottom(file);
                continue;
            }
            if (!changeData) continue;
            this.filesRepository.addFreeFile(file, false, false);
        }
        this.filesRepository.ensureMinFiles();
        this.currentFile = this.filesRepository.pollLastDataFile();
        if (this.currentFile != null) {
            this.currentFile.getFile().open();
            this.currentFile.getFile().position(this.currentFile.getFile().calculateBlockStart(lastDataPos));
        } else {
            this.currentFile = this.filesRepository.getFreeFile();
            this.filesRepository.openFile(this.currentFile, true);
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
        this.filesRepository.pushOpenedFile();
        this.state = 2;
        for (TransactionHolder transaction : loadTransactions.values()) {
            if (!transaction.prepared || transaction.invalid) {
                log.warn("Uncommitted transaction with id " + transaction.transactionID + " found and discarded");
                if (changeData) {
                    this.appendRollbackRecord(transaction.transactionID, false);
                }
                loadManager.failedTransaction(transaction.transactionID, transaction.recordInfos, transaction.recordsToDelete);
                continue;
            }
            for (RecordInfo info : transaction.recordInfos) {
                if (info.id <= maxID.get()) continue;
                maxID.set(info.id);
            }
            PreparedTransactionInfo info = new PreparedTransactionInfo(transaction.transactionID, transaction.extraData);
            info.records.addAll(transaction.recordInfos);
            info.recordsToDelete.addAll(transaction.recordsToDelete);
            loadManager.addPreparedTransaction(info);
        }
        this.checkReclaimStatus();
        return new JournalLoadInformation(this.records.size(), maxID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkReclaimStatus() throws Exception {
        if (this.compactorRunning.get()) {
            return false;
        }
        this.compactingLock.readLock().lock();
        try {
            this.reclaimer.scan(this.getDataFiles());
            for (JournalFile file : this.filesRepository.getDataFiles()) {
                if (!file.isCanReclaim()) continue;
                if (trace) {
                    JournalImpl.trace("Reclaiming file " + file);
                }
                this.filesRepository.removeDataFile(file);
                this.filesRepository.addFreeFile(file, false);
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
        return false;
    }

    private boolean needsCompact() throws Exception {
        JournalFile[] dataFiles = this.getDataFiles();
        long totalLiveSize = 0L;
        for (JournalFile file : dataFiles) {
            totalLiveSize += (long)file.getLiveSize();
        }
        long totalBytes = (long)dataFiles.length * (long)this.fileSize;
        long compactMargin = (long)((float)totalBytes * this.compactPercentage);
        boolean needCompact = totalLiveSize < compactMargin && dataFiles.length > this.compactMinFiles;
        return needCompact;
    }

    private void checkCompact() throws Exception {
        if (this.compactMinFiles == 0) {
            return;
        }
        if (this.state != 2) {
            return;
        }
        if (!this.compactorRunning.get() && this.needsCompact()) {
            this.scheduleCompact();
        }
    }

    private void scheduleCompact() {
        if (!this.compactorRunning.compareAndSet(false, true)) {
            return;
        }
        this.compactorExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JournalImpl.this.compact();
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
                finally {
                    JournalImpl.this.compactorRunning.set(false);
                }
            }
        });
    }

    @Override
    public void setAutoReclaim(boolean autoReclaim) {
        this.autoReclaim = autoReclaim;
    }

    @Override
    public boolean isAutoReclaim() {
        return this.autoReclaim;
    }

    @Override
    public String debug() throws Exception {
        this.reclaimer.scan(this.getDataFiles());
        StringBuilder builder = new StringBuilder();
        for (JournalFile file : this.filesRepository.getDataFiles()) {
            builder.append("DataFile:" + file + " posCounter = " + file.getPosCount() + " reclaimStatus = " + file.isCanReclaim() + " live size = " + file.getLiveSize() + "\n");
            if (!(file instanceof JournalFileImpl)) continue;
            builder.append(((JournalFileImpl)file).debug());
        }
        for (JournalFile file : this.filesRepository.getFreeFiles()) {
            builder.append("FreeFile:" + file + "\n");
        }
        if (this.currentFile != null) {
            builder.append("CurrentFile:" + this.currentFile + " posCounter = " + this.currentFile.getPosCount() + "\n");
            if (this.currentFile instanceof JournalFileImpl) {
                builder.append(((JournalFileImpl)this.currentFile).debug());
            }
        } else {
            builder.append("CurrentFile: No current file at this point!");
        }
        return builder.toString();
    }

    @Override
    public void debugWait() throws Exception {
        this.fileFactory.flush();
        for (JournalTransaction tx : this.transactions.values()) {
            tx.waitCallbacks();
        }
        if (this.filesExecutor != null && !this.filesExecutor.isShutdown()) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.filesExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            });
            latch.await();
        }
    }

    @Override
    public int getDataFilesCount() {
        return this.filesRepository.getDataFilesCount();
    }

    @Override
    public JournalFile[] getDataFiles() {
        return this.filesRepository.getDataFilesArray();
    }

    @Override
    public int getFreeFilesCount() {
        return this.filesRepository.getFreeFilesCount();
    }

    @Override
    public int getOpenedFilesCount() {
        return this.filesRepository.getOpenedFilesCount();
    }

    @Override
    public int getIDMapSize() {
        return this.records.size();
    }

    @Override
    public int getFileSize() {
        return this.fileSize;
    }

    @Override
    public int getMinFiles() {
        return this.minFiles;
    }

    @Override
    public String getFilePrefix() {
        return this.filesRepository.getFilePrefix();
    }

    @Override
    public String getFileExtension() {
        return this.filesRepository.getFileExtension();
    }

    @Override
    public int getMaxAIO() {
        return this.filesRepository.getMaxAIO();
    }

    @Override
    public int getUserVersion() {
        return this.userVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMoveNextFile() throws Exception {
        this.compactingLock.readLock().lock();
        try {
            this.lockAppend.lock();
            try {
                this.moveNextFile(false);
                this.debugWait();
            }
            finally {
                this.lockAppend.unlock();
            }
        }
        finally {
            this.compactingLock.readLock().unlock();
        }
    }

    @Override
    public void perfBlast(int pages) throws Exception {
        new PerfBlast(pages).start();
    }

    @Override
    public synchronized boolean isStarted() {
        return this.state != 0;
    }

    @Override
    public synchronized void start() {
        if (this.state != 0) {
            throw new IllegalStateException("Journal is not stopped");
        }
        this.filesExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "JournalImpl::FilesExecutor");
            }
        });
        this.compactorExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "JournalImpl::CompactorExecutor");
            }
        });
        this.filesRepository.setExecutor(this.filesExecutor);
        this.fileFactory.start();
        this.state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        JournalImpl.trace("Stopping the journal");
        if (this.state == 0) {
            throw new IllegalStateException("Journal is already stopped");
        }
        this.lockAppend.lock();
        try {
            this.state = 0;
            this.compactorExecutor.shutdown();
            if (!this.compactorExecutor.awaitTermination(120L, TimeUnit.SECONDS)) {
                log.warn("Couldn't stop compactor executor after 120 seconds");
            }
            this.filesExecutor.shutdown();
            this.filesRepository.setExecutor(null);
            if (!this.filesExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.warn("Couldn't stop journal executor after 60 seconds");
            }
            this.fileFactory.deactivateBuffer();
            if (this.currentFile != null && this.currentFile.getFile().isOpen()) {
                this.currentFile.getFile().close();
            }
            this.filesRepository.clear();
            this.fileFactory.stop();
            this.currentFile = null;
        }
        finally {
            this.lockAppend.unlock();
        }
    }

    @Override
    public int getNumberOfRecords() {
        return this.records.size();
    }

    protected SequentialFile createControlFile(List<JournalFile> files, List<JournalFile> newFiles, Pair<String, String> cleanupRename) throws Exception {
        ArrayList<Pair<String, String>> cleanupList;
        if (cleanupRename == null) {
            cleanupList = null;
        } else {
            cleanupList = new ArrayList<Pair<String, String>>();
            cleanupList.add(cleanupRename);
        }
        return AbstractJournalUpdateTask.writeControlFile(this.fileFactory, files, newFiles, cleanupList);
    }

    protected void deleteControlFile(SequentialFile controlFile) throws Exception {
        controlFile.delete();
    }

    protected void renameFiles(final List<JournalFile> oldFiles, List<JournalFile> newFiles) throws Exception {
        final CountDownLatch done = new CountDownLatch(1);
        this.filesExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (JournalFile file : oldFiles) {
                    try {
                        JournalImpl.this.filesRepository.addFreeFile(file, false);
                    }
                    catch (Throwable e) {
                        log.warn("Error reinitializing file " + file, e);
                    }
                }
                done.countDown();
            }
        });
        done.await();
        for (JournalFile file : newFiles) {
            String newName = JournalImpl.renameExtensionFile(file.getFile().getFileName(), ".cmp");
            file.getFile().renameTo(newName);
        }
    }

    protected static String renameExtensionFile(String name, String extension) {
        name = name.substring(0, name.lastIndexOf(extension));
        return name;
    }

    protected void onCompactStart() throws Exception {
    }

    protected void onCompactLock() throws Exception {
    }

    protected void onCompactDone() {
    }

    private boolean checkTransactionHealth(JournalFile currentFile, JournalTransaction journalTransaction, List<JournalFile> orderedFiles, int numberOfRecords) {
        return journalTransaction.getCounter(currentFile) == numberOfRecords;
    }

    private static boolean isTransaction(byte recordType) {
        return recordType == 13 || recordType == 14 || recordType == 15 || JournalImpl.isCompleteTransaction(recordType);
    }

    private static boolean isCompleteTransaction(byte recordType) {
        return recordType == 18 || recordType == 17 || recordType == 19;
    }

    private static boolean isContainsBody(byte recordType) {
        return recordType >= 11 && recordType <= 15;
    }

    private static int getRecordSize(byte recordType, int journalVersion) {
        int recordSize = 0;
        switch (recordType) {
            case 11: {
                recordSize = 22;
                break;
            }
            case 12: {
                recordSize = 22;
                break;
            }
            case 13: {
                recordSize = 30;
                break;
            }
            case 14: {
                recordSize = 30;
                break;
            }
            case 16: {
                recordSize = 17;
                break;
            }
            case 15: {
                recordSize = 29;
                break;
            }
            case 17: {
                recordSize = 25;
                break;
            }
            case 18: {
                recordSize = 21;
                break;
            }
            case 19: {
                recordSize = 17;
                break;
            }
            default: {
                throw new IllegalStateException("Record other than expected");
            }
        }
        if (journalVersion >= 2) {
            return recordSize + 1;
        }
        return recordSize;
    }

    private JournalFileImpl readFileHeader(SequentialFile file) throws Exception {
        int readUserVersion;
        ByteBuffer bb = this.fileFactory.newBuffer(16);
        file.read(bb);
        int journalVersion = bb.getInt();
        if (journalVersion != 2) {
            boolean isCompatible = false;
            for (int v : COMPATIBLE_VERSIONS) {
                if (v != journalVersion) continue;
                isCompatible = true;
            }
            if (!isCompatible) {
                throw new HornetQException(6, "Journal files version mismatch. You should export the data from the previous version and import it as explained on the user's manual");
            }
        }
        if ((readUserVersion = bb.getInt()) != this.userVersion) {
            throw new HornetQException(6, "Journal data belong to a different version");
        }
        long fileID = bb.getLong();
        this.fileFactory.releaseBuffer(bb);
        bb = null;
        return new JournalFileImpl(file, fileID, journalVersion);
    }

    public static int initFileHeader(SequentialFileFactory fileFactory, SequentialFile sequentialFile, int userVersion, long fileID) throws Exception {
        ByteBuffer bb = fileFactory.newBuffer(16);
        HornetQBuffer buffer = HornetQBuffers.wrappedBuffer(bb);
        JournalImpl.writeHeader(buffer, userVersion, fileID);
        bb.rewind();
        int bufferSize = bb.limit();
        sequentialFile.position(0L);
        sequentialFile.writeDirect(bb, true);
        return bufferSize;
    }

    public static void writeHeader(HornetQBuffer buffer, int userVersion, long fileID) {
        buffer.writeInt(2);
        buffer.writeInt(userVersion);
        buffer.writeLong(fileID);
    }

    private JournalFile appendRecord(JournalInternalRecord encoder, boolean completeTransaction, boolean sync, JournalTransaction tx, IOAsyncTask parameterCallback) throws Exception {
        IOAsyncTask callback;
        if (this.state != 2) {
            throw new IllegalStateException("The journal is not loaded " + this.state);
        }
        int size = encoder.getEncodeSize();
        if (size > this.fileSize - this.currentFile.getFile().calculateBlockStart(16)) {
            throw new IllegalArgumentException("Record is too large to store " + size);
        }
        if (!this.currentFile.getFile().fits(size)) {
            this.moveNextFile(true);
            if (!this.currentFile.getFile().fits(size)) {
                throw new IllegalStateException("Invalid logic on buffer allocation");
            }
        }
        if (this.currentFile == null) {
            throw new NullPointerException("Current file = null");
        }
        if (tx != null) {
            if (this.fileFactory.isSupportsCallbacks()) {
                TransactionCallback txcallback = tx.getCallback(this.currentFile);
                if (parameterCallback != null) {
                    txcallback.setDelegateCompletion(parameterCallback);
                }
                callback = txcallback;
            } else {
                callback = null;
            }
            if (completeTransaction) {
                tx.fillNumberOfRecords(this.currentFile, encoder);
            }
        } else {
            callback = parameterCallback;
        }
        encoder.setFileID(this.currentFile.getRecordID());
        if (callback != null) {
            this.currentFile.getFile().write(encoder, sync, callback);
        } else {
            this.currentFile.getFile().write(encoder, sync);
        }
        return this.currentFile;
    }

    private void moveNextFile(boolean scheduleReclaim) throws Exception {
        this.filesRepository.closeFile(this.currentFile);
        this.currentFile = this.filesRepository.openFile();
        if (scheduleReclaim) {
            this.scheduleReclaim();
        }
        if (trace) {
            log.trace("moveNextFile: " + this.currentFile);
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
    }

    private void scheduleReclaim() {
        if (this.state != 2) {
            return;
        }
        if (this.autoReclaim && !this.compactorRunning.get()) {
            this.compactorExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!JournalImpl.this.checkReclaimStatus()) {
                            JournalImpl.this.checkCompact();
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            });
        }
    }

    private JournalTransaction getTransactionInfo(long txID) {
        JournalTransaction tx = (JournalTransaction)this.transactions.get(txID);
        if (tx == null) {
            tx = new JournalTransaction(txID, this);
            JournalTransaction trans = this.transactions.putIfAbsent(txID, tx);
            if (trans != null) {
                tx = trans;
            }
        }
        return tx;
    }

    private SyncIOCompletion getSyncCallback(boolean sync) {
        if (this.fileFactory.isSupportsCallbacks()) {
            if (sync) {
                return new SimpleWaitIOCallback();
            }
            return DummyCallback.getInstance();
        }
        return null;
    }

    private void checkControlFile() throws Exception {
        ArrayList<String> dataFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        ArrayList<Pair<String, String>> renames = new ArrayList<Pair<String, String>>();
        SequentialFile controlFile = JournalCompactor.readControlFile(this.fileFactory, dataFiles, newFiles, renames);
        if (controlFile != null) {
            SequentialFile file;
            for (String string : dataFiles) {
                file = this.fileFactory.createSequentialFile(string, 1);
                if (!file.exists()) continue;
                file.delete();
            }
            for (String string : newFiles) {
                file = this.fileFactory.createSequentialFile(string, 1);
                if (!file.exists()) continue;
                String originalName = file.getFileName();
                String newName = originalName.substring(0, originalName.lastIndexOf(".cmp"));
                file.renameTo(newName);
            }
            for (Pair pair : renames) {
                SequentialFile fileTmp = this.fileFactory.createSequentialFile((String)pair.a, 1);
                SequentialFile fileTo = this.fileFactory.createSequentialFile((String)pair.b, 1);
                if (!fileTmp.exists()) continue;
                fileTo.delete();
                fileTmp.renameTo((String)pair.b);
            }
            controlFile.delete();
        }
        this.cleanupTmpFiles(".cmp");
        this.cleanupTmpFiles(".tmp");
    }

    private void cleanupTmpFiles(String extension) throws Exception {
        List<String> leftFiles = this.fileFactory.listFiles(this.getFileExtension() + extension);
        if (leftFiles.size() > 0) {
            log.warn("Temporary files were left unnatended after a crash on journal directory, deleting invalid files now");
            for (String fileToDelete : leftFiles) {
                log.warn("Deleting unnatended file " + fileToDelete);
                SequentialFile file = this.fileFactory.createSequentialFile(fileToDelete, 1);
                file.delete();
            }
        }
    }

    private static boolean isInvalidSize(int fileSize, int bufferPos, int size) {
        if (size < 0) {
            return true;
        }
        int position = bufferPos + size;
        return position > fileSize || position < 0;
    }

    private HornetQBuffer newBuffer(int size) {
        return HornetQBuffers.fixedBuffer(size);
    }

    private class PerfBlast
    extends Thread {
        private final int pages;

        private PerfBlast(int pages) {
            super("hornetq-perfblast-thread");
            this.pages = pages;
        }

        @Override
        public void run() {
            try {
                JournalImpl.this.lockAppend.lock();
                final ByteArrayEncoding byteEncoder = new ByteArrayEncoding(new byte[131072]);
                JournalInternalRecord blastRecord = new JournalInternalRecord(){

                    @Override
                    public int getEncodeSize() {
                        return byteEncoder.getEncodeSize();
                    }

                    @Override
                    public void encode(HornetQBuffer buffer) {
                        byteEncoder.encode(buffer);
                    }
                };
                for (int i = 0; i < this.pages; ++i) {
                    JournalImpl.this.appendRecord(blastRecord, false, false, null, null);
                }
                JournalImpl.this.lockAppend.unlock();
            }
            catch (Exception e) {
                log.error("Failed to perf blast", e);
            }
        }
    }

    private static class JournalFileComparator
    implements Comparator<JournalFile> {
        private JournalFileComparator() {
        }

        @Override
        public int compare(JournalFile f1, JournalFile f2) {
            long id2;
            long id1 = f1.getFileID();
            return id1 < (id2 = f2.getFileID()) ? -1 : (id1 == id2 ? 0 : 1);
        }
    }

    private static class TransactionHolder {
        public final long transactionID;
        public final List<RecordInfo> recordInfos = new ArrayList<RecordInfo>();
        public final List<RecordInfo> recordsToDelete = new ArrayList<RecordInfo>();
        public boolean prepared;
        public boolean invalid;
        public byte[] extraData;

        public TransactionHolder(long id) {
            this.transactionID = id;
        }
    }

    private static class NullEncoding
    implements EncodingSupport {
        private static NullEncoding instance = new NullEncoding();

        private NullEncoding() {
        }

        public static NullEncoding getInstance() {
            return instance;
        }

        @Override
        public void decode(HornetQBuffer buffer) {
        }

        @Override
        public void encode(HornetQBuffer buffer) {
        }

        @Override
        public int getEncodeSize() {
            return 0;
        }
    }
}

