/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.security.impl;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.HierarchicalRepositoryChangeListener;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.TypedProperties;

public class SecurityStoreImpl
implements SecurityStore,
HierarchicalRepositoryChangeListener {
    private static final Logger log = Logger.getLogger(SecurityStoreImpl.class);
    private final boolean trace = log.isTraceEnabled();
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final HornetQSecurityManager securityManager;
    private final ConcurrentMap<String, ConcurrentHashSet<SimpleString>> cache = new ConcurrentHashMap<String, ConcurrentHashSet<SimpleString>>();
    private final long invalidationInterval;
    private volatile long lastCheck;
    private final boolean securityEnabled;
    private final String managementClusterUser;
    private final String managementClusterPassword;
    private final NotificationService notificationService;

    public SecurityStoreImpl(HierarchicalRepository<Set<Role>> securityRepository, HornetQSecurityManager securityManager, long invalidationInterval, boolean securityEnabled, String managementClusterUser, String managementClusterPassword, NotificationService notificationService) {
        this.securityRepository = securityRepository;
        this.securityManager = securityManager;
        this.invalidationInterval = invalidationInterval;
        this.securityEnabled = securityEnabled;
        this.managementClusterUser = managementClusterUser;
        this.managementClusterPassword = managementClusterPassword;
        this.notificationService = notificationService;
    }

    @Override
    public void authenticate(String user, String password) throws Exception {
        if (this.securityEnabled) {
            if (this.managementClusterUser.equals(user)) {
                if (this.trace) {
                    log.trace("Authenticating cluster admin user");
                }
                if (!this.managementClusterPassword.equals(password)) {
                    throw new HornetQException(105, "Unable to validate user: " + user);
                }
                return;
            }
            if (!this.securityManager.validateUser(user, password)) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString(user));
                    Notification notification = new Notification(null, NotificationType.SECURITY_AUTHENTICATION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                throw new HornetQException(105, "Unable to validate user: " + user);
            }
        }
    }

    @Override
    public void check(SimpleString address, CheckType checkType, ServerSession session) throws Exception {
        if (this.securityEnabled) {
            String user;
            if (this.trace) {
                log.trace("checking access permissions to " + address);
            }
            if (this.checkCached(address, user = session.getUsername(), checkType)) {
                return;
            }
            String saddress = address.toString();
            Set<Role> roles = this.securityRepository.getMatch(saddress);
            if (this.managementClusterUser.equals(user) && session.getPassword().equals(this.managementClusterPassword)) {
                return;
            }
            if (!this.securityManager.validateUserAndRole(user, session.getPassword(), roles, checkType)) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, address);
                    props.putSimpleStringProperty(ManagementHelper.HDR_CHECK_TYPE, new SimpleString(checkType.toString()));
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString(user));
                    Notification notification = new Notification(null, NotificationType.SECURITY_PERMISSION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                throw new HornetQException(105, "User: " + session.getUsername() + " doesn't have permission='" + (Object)((Object)checkType) + "' on address " + saddress);
            }
            ConcurrentHashSet<SimpleString> set = new ConcurrentHashSet<SimpleString>();
            ConcurrentHashSet act = this.cache.putIfAbsent(user + "." + checkType.name(), set);
            if (act != null) {
                set = act;
            }
            set.add(address);
        }
    }

    @Override
    public void onChange() {
        this.invalidateCache();
    }

    private void invalidateCache() {
        this.cache.clear();
    }

    private boolean checkCached(SimpleString dest, String user, CheckType checkType) {
        long now = System.currentTimeMillis();
        boolean granted = false;
        if (now - this.lastCheck > this.invalidationInterval) {
            this.invalidateCache();
        } else {
            ConcurrentHashSet act = (ConcurrentHashSet)this.cache.get(user + "." + checkType.name());
            if (act != null) {
                granted = act.contains(dest);
            }
        }
        this.lastCheck = now;
        return granted;
    }
}

