/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.utils.Future;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUID;

public class BridgeImpl
implements Bridge,
SessionFailureListener,
SendAcknowledgementHandler {
    private static final Logger log = Logger.getLogger(BridgeImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final SimpleString JMS_QUEUE_ADDRESS_PREFIX = new SimpleString("jms.queue.");
    private static final SimpleString JMS_TOPIC_ADDRESS_PREFIX = new SimpleString("jms.topic.");
    protected final ServerLocatorInternal serverLocator;
    private final UUID nodeUUID;
    private final SimpleString name;
    private final Queue queue;
    protected final Executor executor;
    private final Filter filter;
    private final SimpleString forwardingAddress;
    private final java.util.Queue<MessageReference> refs = new ConcurrentLinkedQueue<MessageReference>();
    private final Transformer transformer;
    private volatile ClientSessionFactory csf;
    protected volatile ClientSessionInternal session;
    private volatile ClientProducer producer;
    private volatile boolean started;
    private final boolean useDuplicateDetection;
    private volatile boolean active;
    private volatile boolean stopping;
    private final String user;
    private final String password;
    private boolean activated;
    private NotificationService notificationService;

    public BridgeImpl(ServerLocatorInternal serverLocator, UUID nodeUUID, SimpleString name, Queue queue, Executor executor, SimpleString filterString, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, Transformer transformer, boolean useDuplicateDetection, String user, String password, boolean activated, StorageManager storageManager) throws Exception {
        this.serverLocator = serverLocator;
        this.nodeUUID = nodeUUID;
        this.name = name;
        this.queue = queue;
        this.executor = executor;
        this.filter = FilterImpl.createFilter(filterString);
        this.forwardingAddress = forwardingAddress;
        this.transformer = transformer;
        this.useDuplicateDetection = useDuplicateDetection;
        this.user = user;
        this.password = password;
        this.activated = activated;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.activated) {
            this.activate();
        }
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.BRIDGE_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    private void cancelRefs() throws Exception {
        MessageReference ref;
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        while ((ref = this.refs.poll()) != null) {
            list.addFirst(ref);
        }
        Queue queue = null;
        long timeBase = System.currentTimeMillis();
        for (MessageReference ref2 : list) {
            queue = ref2.getQueue();
            queue.cancel(ref2, timeBase);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started && this.csf != null) {
            this.csf.close();
        }
        log.info("Bridge " + this.name + " being stopped");
        this.stopping = true;
        this.executor.execute(new StopRunnable());
        this.waitForRunnablesToComplete();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                log.warn("unable to send notification when broadcast group is stopped", e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void activate() {
        this.activated = true;
        this.executor.execute(new CreateObjectsRunnable());
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getForwardingAddress() {
        return this.forwardingAddress;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isUseDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    @Override
    public RemotingConnection getForwardingConnection() {
        if (this.session == null) {
            return null;
        }
        return this.session.getConnection();
    }

    @Override
    public void sendAcknowledged(Message message) {
        try {
            MessageReference ref = this.refs.poll();
            if (ref != null) {
                ref.getQueue().acknowledge(ref);
            }
        }
        catch (Exception e) {
            log.error("Failed to ack", e);
        }
    }

    protected ServerMessage beforeForward(ServerMessage message) {
        if (this.useDuplicateDetection) {
            byte[] bytes = BridgeImpl.getDuplicateBytes(this.nodeUUID, message.getMessageID());
            message.putBytesProperty(MessageImpl.HDR_BRIDGE_DUPLICATE_ID, bytes);
        }
        if (this.transformer != null) {
            message = this.transformer.transform(message);
        }
        return message;
    }

    public static byte[] getDuplicateBytes(UUID nodeUUID, long messageID) {
        byte[] bytes = new byte[24];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.put(nodeUUID.asBytes());
        bb.putLong(messageID);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (this.filter != null && !this.filter.match(ref.getMessage())) {
            return HandleStatus.NO_MATCH;
        }
        BridgeImpl bridgeImpl = this;
        synchronized (bridgeImpl) {
            if (!this.active) {
                log.debug(this.name + "::Ignoring reference on bridge as it is set to iniactive ref=" + ref);
                return HandleStatus.BUSY;
            }
            if (isTrace) {
                log.trace("Bridge " + this.name + " is handling reference=" + ref);
            }
            ref.handled();
            ServerMessage message = ref.getMessage();
            this.refs.add(ref);
            message = this.beforeForward(message);
            SimpleString dest = this.forwardingAddress != null ? this.forwardingAddress : message.getAddress();
            try {
                this.producer.send(dest, (Message)message);
            }
            catch (HornetQException e) {
                log.warn("Unable to send message, will try again once bridge reconnects", e);
                this.refs.remove(ref);
                return HandleStatus.BUSY;
            }
            return HandleStatus.HANDLED;
        }
    }

    @Override
    public void connectionFailed(HornetQException me, boolean failedOver) {
        log.warn(this.name + "::Connection failed with failedOver=" + failedOver, me);
        this.fail(false);
    }

    @Override
    public void beforeReconnect(HornetQException exception) {
        log.warn(this.name + "::Connection failed before reconnect ", exception);
        this.fail(true);
    }

    private void waitForRunnablesToComplete() {
        Future future = new Future();
        this.executor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Timed out waiting to stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(boolean beforeReconnect) {
        block8: {
            log.debug(this.name + "::BridgeImpl::fail being called, beforeReconnect=" + beforeReconnect);
            if (this.session.getConnection().isDestroyed()) {
                log.debug(this.name + "::Connection is destroyed, active = false now");
                this.active = false;
            }
            try {
                if (this.session.getConnection().isDestroyed()) break block8;
                if (beforeReconnect) {
                    BridgeImpl bridgeImpl = this;
                    synchronized (bridgeImpl) {
                        log.debug(this.name + "::Connection is destroyed, active = false now");
                    }
                    this.cancelRefs();
                    break block8;
                }
                this.afterConnect();
                log.debug(this.name + "::After reconnect, setting active=true now");
                this.active = true;
                if (this.queue != null) {
                    this.queue.deliverAsync();
                }
            }
            catch (Exception e) {
                log.error("Failed to cancel refs", e);
            }
        }
    }

    protected void afterConnect() throws Exception {
    }

    protected ClientSessionFactory createSessionFactory() throws Exception {
        return this.serverLocator.createSessionFactory();
    }

    protected synchronized boolean createObjects() {
        if (!this.started) {
            return false;
        }
        boolean retry = false;
        int retryCount = 0;
        do {
            log.info("Connecting bridge " + this.name + " to its destination [" + this.nodeUUID.toString() + "]");
            try {
                this.csf = this.createSessionFactory();
                this.session = (ClientSessionInternal)this.csf.createSession(this.user, this.password, false, true, true, true, 1);
                if (this.forwardingAddress != null) {
                    ClientSession.BindingQuery query = null;
                    try {
                        query = this.session.bindingQuery(this.forwardingAddress);
                    }
                    catch (Throwable e) {
                        log.warn("Error on querying binding. Retrying", e);
                        retry = true;
                        Thread.sleep(100L);
                        continue;
                    }
                    if (this.forwardingAddress.startsWith(JMS_QUEUE_ADDRESS_PREFIX) || this.forwardingAddress.startsWith(JMS_TOPIC_ADDRESS_PREFIX)) {
                        if (!query.isExists()) {
                            if (this.serverLocator.getReconnectAttempts() > 0 && ++retryCount > this.serverLocator.getReconnectAttempts()) {
                                log.warn("Retried " + this.forwardingAddress + " up to the configured reconnectAttempts(" + this.serverLocator.getReconnectAttempts() + "). Giving up now. The bridge " + this.getName() + " will not be activated");
                                return false;
                            }
                            log.warn("Address " + this.forwardingAddress + " doesn't have any bindings yet, retry #(" + retryCount + ")");
                            Thread.sleep(this.serverLocator.getRetryInterval());
                            retry = true;
                            this.csf.close();
                            this.session.close();
                            continue;
                        }
                    } else if (!query.isExists()) {
                        log.info("Bridge " + this.getName() + " connected to fowardingAddress=" + this.getForwardingAddress() + ". " + this.getForwardingAddress() + " doesn't have any bindings what means messages will be ignored until a binding is created.");
                    }
                }
                if (this.session == null) {
                    return false;
                }
                this.producer = this.session.createProducer();
                this.session.addFailureListener(this);
                this.session.setSendAcknowledgementHandler(this);
                this.afterConnect();
                this.active = true;
                this.queue.addConsumer(this);
                this.queue.deliverAsync();
                log.info("Bridge " + this.name + " is connected [" + this.nodeUUID + "-> " + this.name + "]");
                return true;
            }
            catch (HornetQException e) {
                if (this.csf != null) {
                    this.csf.close();
                }
                if (e.getCode() == 112) {
                    log.warn("Server is starting, retry to create the session for bridge " + this.name);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    retry = true;
                    continue;
                }
                log.warn("Bridge " + this.name + " is unable to connect to destination. It will be disabled.", e);
                return false;
            }
            catch (Exception e) {
                log.warn("Bridge " + this.name + " is unable to connect to destination. It will be disabled.", e);
                return false;
            }
        } while (retry && !this.stopping);
        return false;
    }

    private class CreateObjectsRunnable
    implements Runnable {
        private CreateObjectsRunnable() {
        }

        @Override
        public synchronized void run() {
            if (!BridgeImpl.this.createObjects()) {
                BridgeImpl.this.active = false;
                BridgeImpl.this.started = false;
            }
        }
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BridgeImpl bridgeImpl = BridgeImpl.this;
                synchronized (bridgeImpl) {
                    if (!BridgeImpl.this.started) {
                        return;
                    }
                    log.debug("Closing Session for bridge " + BridgeImpl.this.name);
                    if (BridgeImpl.this.session != null) {
                        BridgeImpl.this.session.close();
                    }
                    BridgeImpl.this.started = false;
                    BridgeImpl.this.active = false;
                }
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                BridgeImpl.this.cancelRefs();
                if (BridgeImpl.this.queue != null) {
                    BridgeImpl.this.queue.deliverAsync();
                }
                log.info("stopped bridge " + BridgeImpl.this.name);
            }
            catch (Exception e) {
                log.error("Failed to stop bridge", e);
            }
        }
    }
}

