/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.IOException;
import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.jmx.PackageStateMBeanExt;
import org.jboss.osgi.jmx.internal.AbstractState;
import org.osgi.framework.BundleContext;

public class PackageStateExt
extends AbstractState
implements PackageStateMBeanExt {
    private static final Logger log = Logger.getLogger(PackageStateExt.class);

    public PackageStateExt(BundleContext context, MBeanServer mbeanServer) {
        super(context, mbeanServer);
    }

    @Override
    ObjectName getObjectName() {
        return ObjectNameFactory.create("jboss.osgi:service=jmx,type=PackageState");
    }

    @Override
    StandardMBean getStandardMBean() throws NotCompliantMBeanException {
        return new StandardMBean(this, PackageStateMBeanExt.class);
    }

    public long[] getExportingBundles(String packageName, String version) throws IOException {
        long[] bundleIds = this.getPackageStateMBean().getExportingBundles(packageName, version);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getExportingBundles [packageName=" + packageName + ",version=" + version + "] => " + (bundleIds != null ? Arrays.asList(new long[][]{bundleIds}) : null)));
        }
        return bundleIds;
    }

    public long[] getImportingBundles(String packageName, String version, long exporter) throws IOException {
        long[] bundleIds = this.getPackageStateMBean().getImportingBundles(packageName, version, exporter);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getImportingBundles [packageName=" + packageName + ",version=" + version + ",exporter=" + exporter + "] => " + (bundleIds != null ? Arrays.asList(new long[][]{bundleIds}) : null)));
        }
        return bundleIds;
    }

    public boolean isRemovalPending(String packageName, String version, long exporter) throws IOException {
        boolean removalPending = this.getPackageStateMBean().isRemovalPending(packageName, version, exporter);
        if (log.isTraceEnabled()) {
            log.trace((Object)("isRemovalPending [packageName=" + packageName + ",version=" + version + ",exporter=" + exporter + "] => " + removalPending));
        }
        return removalPending;
    }

    public TabularData listPackages() throws IOException {
        TabularData packages = this.getPackageStateMBean().listPackages();
        if (log.isTraceEnabled()) {
            log.trace((Object)("listPackages: " + packages));
        }
        return packages;
    }
}

