/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.felix.metatype.internal.Activator;
import org.apache.felix.metatype.internal.MetaTypeInformationImpl;
import org.apache.felix.metatype.internal.ServiceMetaTypeInformation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.xmlpull.v1.XmlPullParserException;

class MetaTypeServiceImpl
implements MetaTypeService {
    private final BundleContext bundleContext;

    MetaTypeServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public MetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        MetaTypeInformation mti = this.fromDocuments(bundle);
        if (mti != null) {
            return mti;
        }
        return new ServiceMetaTypeInformation(this.bundleContext, bundle);
    }

    private MetaTypeInformation fromDocuments(Bundle bundle) {
        MetaDataReader reader = new MetaDataReader();
        Enumeration docs = bundle.findEntries("OSGI-INF/metatype", "*.xml", false);
        if (docs == null || !docs.hasMoreElements()) {
            return null;
        }
        MetaTypeInformationImpl cmti = new MetaTypeInformationImpl(bundle);
        while (docs.hasMoreElements()) {
            URL doc = (URL)docs.nextElement();
            try {
                MetaData metaData = reader.parse(doc);
                if (metaData == null) continue;
                cmti.addMetaData(metaData);
            }
            catch (XmlPullParserException xppe) {
                Activator.log(1, "fromDocuments: Error parsing document " + doc, xppe);
            }
            catch (IOException ioe) {
                Activator.log(1, "fromDocuments: Error accessing document " + doc, ioe);
            }
        }
        return cmti;
    }
}

