/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ALLOW_CORE_TIMEOUT("allow-core-timeout"),
    BLOCKING("blocking"),
    COUNT("count"),
    GROUP_NAME("group-name"),
    NAME("name"),
    THREAD_NAME_PATTERN("thread-name-pattern"),
    TIME("time"),
    PER_CPU("per-cpu"),
    PRIORITY("priority"),
    UNIT("unit"),
    VALUE("value");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

